% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbQueryHistory.R
\name{dbQueryHistory}
\alias{dbQueryHistory}
\title{Show history of queries loaded into collection}
\usage{
dbQueryHistory(con, verbose = FALSE)
}
\arguments{
\item{con}{A database connection object, created with
\code{nodbi}. See section `1 - Database connection` in
\link{ctrdata}.}

\item{verbose}{If \code{TRUE}, prints additional information
(default \code{FALSE}).}
}
\value{
A data frame (or tibble, if \code{tibble} is loaded)
 with columns: `query-timestamp`, `query-register`,
 `query-records` (note: this is the number of records loaded when last
 executing \link{ctrLoadQueryIntoDb}, not the total record number) and
 `query-term`, with one row for each time that
 \link{ctrLoadQueryIntoDb} loaded trial records into this collection.
}
\description{
Note that a new entry is added to the history of queries when
\link{ctrLoadQueryIntoDb} retrieves at least 1 clinical trial.
}
\examples{

dbc <- nodbi::src_sqlite(
  dbname = system.file("extdata", "demo.sqlite", package = "ctrdata"),
  collection = "my_trials",
  flags = RSQLite::SQLITE_RO)

dbQueryHistory(con = dbc)

}
