% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/solver.R, R/model-lemna_setac.R,
%   R/model-magma.R, R/model-lemna_schmitt.R, R/model-algae.R,
%   R/model-deb_abj.R, R/model-debtox.R, R/model-deb_daphnia.R, R/model-guts.R,
%   R/model-guts_red.R
\name{solver}
\alias{solver}
\alias{solver,ANY-method}
\alias{solver,LemnaSetac-method}
\alias{solver,Magma-method}
\alias{solver,LemnaSchmitt-method}
\alias{solver,AlgaeWeber-method}
\alias{solver,AlgaeTKTD-method}
\alias{solver,AlgaeSimple-method}
\alias{solver,DebAbj-method}
\alias{solver,DebTox-method}
\alias{solver,DebDaphnia-method}
\alias{solver,GutsSd-method}
\alias{solver,GutsIt-method}
\alias{solver,GutsRedSd-method}
\alias{solver,GutsRedIt-method}
\title{Calls ODE solver for a particular model}
\usage{
solver(scenario, ...)

\S4method{solver}{ANY}(scenario, ...)

\S4method{solver}{LemnaSetac}(scenario, ...)

\S4method{solver}{Magma}(scenario, ...)

\S4method{solver}{LemnaSchmitt}(scenario, ...)

\S4method{solver}{AlgaeWeber}(scenario, method = "lsoda", hmax = 0.1, nout = 1, ...)

\S4method{solver}{AlgaeTKTD}(scenario, method = "lsoda", hmax = 0.1, ...)

\S4method{solver}{AlgaeSimple}(scenario, method = "lsoda", hmax = 0.1, ...)

\S4method{solver}{DebAbj}(scenario, ...)

\S4method{solver}{DebTox}(scenario, method = "ode45", ...)

\S4method{solver}{DebDaphnia}(scenario, ...)

\S4method{solver}{GutsSd}(scenario, ...)

\S4method{solver}{GutsIt}(scenario, ...)

\S4method{solver}{GutsRedSd}(scenario, ...)

\S4method{solver}{GutsRedIt}(scenario, ...)
}
\arguments{
\item{scenario}{\link{scenario} object}

\item{...}{additional parameters passed on to \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{method}{string, selects the numerical solver used by \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{hmax}{numeric, sets the maximum step length in time, see \code{\link[deSolve:ode]{deSolve::ode()}}}

\item{nout}{numeric, the  number of additional output variables returned by
the model, see \code{vignette("compiledCode", "deSolve")} for details.
If and which output variables are available depends on the scenario
type, please refer to the documentation of the model in question.}
}
\value{
\code{data.frame} with simulation results
}
\description{
Please refer to the \emph{Modeling Howto} vignette on how to implement custom
models by overloading the \code{solver} function.
}
\details{
Some solvers may set reasonable default values for e.g. maximum step
length in time (\code{hmax}), but not all do. Please check the model documentation for
details.
}
\section{Methods (by class)}{
\itemize{
\item \code{solver(ANY)}: Default solver, raises an error

\item \code{solver(LemnaSetac)}: Numerically integrates Lemna_SETAC scenarios

\item \code{solver(Magma)}: Numerically integrates \code{Magma} scenarios

\item \code{solver(LemnaSchmitt)}: Numerically integrates Lemna_Schmitt scenarios

\item \code{solver(AlgaeWeber)}: numerically integrates Algae_Weber scenarios

\item \code{solver(AlgaeTKTD)}: numerically integrates Algae_TKTD scenarios

\item \code{solver(AlgaeSimple)}: numerically integrates Algae_Simple scenarios

\item \code{solver(DebAbj)}: Numerically integrates DEB_abj scenarios

\item \code{solver(DebTox)}: Numerically integrates \emph{DEBtox} scenarios

\item \code{solver(DebDaphnia)}: (deprecated) Numerically integrates \emph{DEBtox_Daphnia} scenarios

\item \code{solver(GutsSd)}: Numerically integrates GUTS-SD scenarios

\item \code{solver(GutsIt)}: Numerically integrates GUTS-IT scenarios

\item \code{solver(GutsRedSd)}: Numerically integrates GUTS-RED-SD scenarios

\item \code{solver(GutsRedIt)}: Numerically integrates GUTS-RED-IT scenarios

}}
