% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_cop_mle.R
\name{fit_cylcop_ml}
\alias{fit_cylcop_ml}
\alias{optML}
\title{Estimate Parameters of a Circular-Linear Copula According to Maximum Likelihood}
\usage{
fit_cylcop_ml(
  copula,
  theta,
  x,
  parameters = NULL,
  start = NULL,
  lower = NULL,
  upper = NULL,
  optim.method = "L-BFGS-B",
  optim.control = list(maxit = 100),
  estimate.variance = FALSE,
  traceOpt = FALSE
)

optML(
  copula,
  theta,
  x,
  parameters = NULL,
  start = NULL,
  lower = NULL,
  upper = NULL,
  optim.method = "L-BFGS-B",
  optim.control = list(maxit = 100),
  estimate.variance = FALSE,
  traceOpt = FALSE
)
}
\arguments{
\item{copula}{\R object of class '\code{\linkS4class{cyl_copula}}'.}

\item{theta}{\link[base]{numeric} \link[base]{vector} of angles
(measurements of a circular variable) or "circular" component of pseudo-observations.}

\item{x}{\link[base]{numeric} \link[base]{vector} of step lengths
(measurements of a linear variable) or "linear" component of pseudo-observations.}

\item{parameters}{\link[base]{vector} of \link[base]{character} strings
holding the names of the parameters to be optimized.
  These can be any parameters in \code{copula@parameters}. Default is to
  optimize the first 2 parameters or the single parameter if \code{copula} only
  has 1.}

\item{start}{\link[base]{vector} of starting values of the parameters. Default is
to take the starting values from \code{copula}.}

\item{lower}{(optional) \link[base]{vector} of lower bounds of the parameters.}

\item{upper}{(optional) \link[base]{vector} of upper bounds of the parameters.}

\item{optim.method}{\link[base]{character} string, optimizer used in
\code{\link[stats]{optim}()}, can be
 \code{"Nelder-Mead"}, \code{"BFGS"}, \code{"CG"}, \code{"L-BFGS-B"},
 \code{"SANN"}, or \code{"Brent"}. Default is "L-BFGS-B".}

\item{optim.control}{\link[base]{list} of additional controls passed to
\code{\link[stats]{optim}()}.}

\item{estimate.variance}{\link[base]{logical} value, denoting whether to include an
estimate of the variance (NOT YET IMPLEMENTED).}

\item{traceOpt}{\link[base]{logical} value, whether to print information regarding
convergence, current values, etc. during the optimization process.}
}
\value{
A list of length 3 containing the same type of '\code{\linkS4class{cyl_copula}}'
 object as \code{copula}, but with optimized parameters, the log-likelihood
 and the AIC.
}
\description{
The code of this function is based on \code{copula::\link[copula]{fitCopula}()}.
A circular-linear copula is fit to a set of bivariate observations.
}
\details{
The data is first converted to pseudo observations to which
the copula is then fit. Therefore, the result of the optimization will be
exactly the same whether measurements (\code{theta=theta} and \code{x=x})
or pseudo observations (\code{theta=copula::\link[copula]{pobs}(theta,x)[,1]}
and \code{x=copula::\link[copula]{pobs}(theta,x)[,2]}) are provided.
If you wish to fit parameters of a '\code{\link[copula:Copula-class]{Copula}}' object
(package '\pkg{copula}'), use the function \code{copula::\link[copula]{fitCopula}()}.
\code{optML()} is an alias for \code{fit_cylcop_ml}.
}
\examples{
set.seed(123)

sample <- rcylcop(100,cyl_quadsec(0.1))
fit_cylcop_ml(copula = cyl_quadsec(),
  theta = sample[,1],
  x = sample[,2],
  parameters = "a",
  start = 0
)
fit_cylcop_ml(copula = cyl_rect_combine(copula::frankCopula()),
  theta = sample[,1],
  x = sample[,2],
  parameters = "alpha",
  start = 1
)


sample <- rjoint(
  n = 100,
  copula = cyl_cubsec(0.1, -0.08),
  marginal_1 = list(name = "vonmisesmix", coef = list(
     mu = c(pi, 0),
     kappa = c(2, 5),
     prop = c(0.3, 0.7)
    )),
  marginal_2 = list(name = "exp", coef = list(0.3))
  )
  fit_cylcop_ml(copula = cyl_cubsec(),
  theta = sample[,1],
  x = sample[,2],
  parameters = c("a","b"),
  start = c(0,0),
  upper= c(0.1, 1/(2*pi))
)

optML(copula = cyl_quadsec(),
  theta = sample[,1],
  x = sample[,2],
  parameters = "a",
  start = 0
)
}
\references{
\insertRef{Hodelappl}{cylcop}

\insertRef{Hodelmethod}{cylcop}
}
\seealso{
\code{copula::\link[copula]{fitCopula}()}, \code{\link{fit_cylcop_cor}()},
\code{\link{opt_auto}()}.
}
