% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api.R
\name{po_bar}
\alias{po_bar}
\title{Bar}
\usage{
po_bar(d3po, ..., data = NULL, inherit_daes = TRUE)
}
\arguments{
\item{d3po}{Either the output of \code{\link[=d3po]{d3po()}} or \code{\link[=d3po_proxy]{d3po_proxy()}}.}

\item{...}{Aesthetics, see \code{\link[=daes]{daes()}}.}

\item{data}{Any dataset to use for plot, overrides data passed
to \code{\link[=d3po]{d3po()}}.}

\item{inherit_daes}{Whether to inherit aesthetics previous specified.}
}
\value{
an 'htmlwidgets' object with the desired interactive plot
}
\description{
Draw a bar chart.
}
\examples{
if (interactive()) {
  trade_by_continent <- d3po::trade
  trade_by_continent <- aggregate(
    trade ~ reporter_continent,
    data = d3po::trade,
    FUN = sum
  )

  # Assign colors to continents
  # my_pal <- tintin::tintin_pal()(7)
  # [1] "#358DA1" "#4D636A" "#624743" "#9F3531" "#9F8F6F" "#CA7C4D" "#D81A1E"

  my_pal <- c("#358DA1", "#4D636A", "#624743", "#9F3531", "#9F8F6F", "#CA7C4D", "#D81A1E")

  names(my_pal) <- c(
    "Africa", "Antarctica", "Asia",
    "Europe", "North America", "Oceania", "South America"
  )

  d3po(trade_by_continent, width = 800, height = 600) \%>\%
    po_bar(daes(x = reporter_continent, y = trade, color = my_pal)) \%>\%
    po_labels(
      x = "Continent",
      y = "Trade (USD billion)",
      title = "Total Trade by Reporter Continent in 2023"
    )
}
}
