% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/core_bayes_estimate.R
\name{call_log_posterior_m}
\alias{call_log_posterior_m}
\title{Metropolis Acceptance Step for Vectorized MCMC Sampling}
\usage{
call_log_posterior_m(
  proposal_mat,
  prev_prms_mat,
  prev_pis,
  prev_lls,
  level,
  re_eval,
  ...
)
}
\arguments{
\item{proposal_mat}{a numeric matrix of proposed parameter values.
Each column corresponds to one chain; rows represent parameters.}

\item{prev_prms_mat}{a numeric matrix of current (previous) parameter values.
Must have the same dimensions as \code{proposal_mat}.}

\item{prev_pis}{a numeric vector of current log-posterior values for each
chain.}

\item{prev_lls}{a numeric vector of current log-likelihood values for each
chain.}

\item{level}{a character string specifying the sampling level, either
\code{"lower"}, \code{"hyper"}, or \code{"none"}. Determines whether to call
\code{\link[=log_posterior_lower]{log_posterior_lower()}} or \code{\link[=log_posterior_hyper]{log_posterior_hyper()}}.}

\item{re_eval}{logical. If \code{TRUE}, the log-posterior and log-likelihood for
the current parameters are re-evaluated.}

\item{...}{Additional arguments passed to \code{\link[=log_posterior_lower]{log_posterior_lower()}} or
\code{\link[=log_posterior_hyper]{log_posterior_hyper()}}, depending on the \code{level}.}
}
\value{
A list with three elements:
\describe{
\item{\code{pis}}{A numeric vector of updated log-posterior values.}
\item{\code{lls}}{A numeric vector of updated log-likelihood values.}
\item{\code{accept}}{A logical vector of length equal to the number of chains,
indicating which proposals were accepted.}
}
}
\description{
This internal function computes the Metropolis acceptance decision
for a set of MCMC proposals, using either hierarchical or non-hierarchical
posterior evaluation. It returns updated log-posterior and log-likelihood
values, as well as a logical vector indicating accepted proposals.
}
\details{
This function implements a vectorized Metropolis acceptance step for
multiple MCMC chains simultaneously. The posterior is calculated using
either \code{\link[=log_posterior_lower]{log_posterior_lower()}} for subject-level parameters or
\code{\link[=log_posterior_hyper]{log_posterior_hyper()}} for group-level parameters.

Log-posterior and log-likelihood values are only updated where proposals
were accepted. In cases where proposals yield invalid posteriors (i.e.,
\code{NA}), they are automatically rejected.
}
\keyword{internal}
