% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prm_cond_combo_2_labels}
\alias{prm_cond_combo_2_labels}
\title{Generate Parameter-Condition Labels}
\usage{
prm_cond_combo_2_labels(prms_cond_combo, sep = ".")
}
\arguments{
\item{prms_cond_combo}{a 2-row character matrix where each column represents
a unique parameter-condition combination.}

\item{sep}{Separator for parameter and condition labels (default: "~").}
}
\value{
A vector of labels with as many entries as the columns of
\code{prms_cond_combo} had, combining parameter and condition (if necessary).

If the parameter labels are already unique (because all parameters do not
vary across conditions or are selectively used for one condition), then
only these parameter labels are returned
}
\description{
Creates a vector of labels from a parameter-condition combination matrix,
resulting from a call to \link{prms_cond_combo}. Used, for instance, in
\link{coef.drift_dm}.
}
\keyword{internal}
