% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trans_hierarchy_cut.R
\name{hierarchy_cut}
\alias{hierarchy_cut}
\title{Hierarchy mapping by cut}
\usage{
hierarchy_cut(attribute, breaks, labels = NULL, new_attribute = NULL)
}
\arguments{
\item{attribute}{numeric attribute to discretize}

\item{breaks}{numeric breakpoints for \code{cut}}

\item{labels}{optional labels for the cut intervals}

\item{new_attribute}{name of the new attribute (default: "attribute.Level")}
}
\value{
returns an object of class \code{hierarchy_cut}
}
\description{
Create a categorical hierarchy from a numeric attribute using cut points.
}
\examples{
data(iris)
hc <- hierarchy_cut(
 "Sepal.Length",
 breaks = c(-Inf, 5.5, 6.5, Inf),
 labels = c("baixo", "medio", "alto")
)
iris_h <- transform(hc, iris)
table(iris_h$Sepal.Length.Level)
}
