% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gl.edit.recode.pop.r
\name{gl.edit.recode.pop}
\alias{gl.edit.recode.pop}
\title{Creates or edits and applies a population re-assignment table}
\usage{
gl.edit.recode.pop(
  x,
  pop.recode = NULL,
  out.recode.file = NULL,
  outpath = NULL,
  recalc = FALSE,
  mono.rm = FALSE,
  verbose = NULL
)
}
\arguments{
\item{x}{Name of the genlight object  [required].}

\item{pop.recode}{Path to recode file [default NULL].}

\item{out.recode.file}{Name of the file to output the new individual labels
[default NULL].}

\item{outpath}{Directory to save the plot RDS files [default as specified 
by the global working directory or tempdir()]}

\item{recalc}{If TRUE, recalculate the locus metadata statistics
[default TRUE].}

\item{mono.rm}{If TRUE, remove monomorphic loci [default TRUE].}

\item{verbose}{Verbosity: 0, silent or fatal errors; 1, begin and end; 2,
progress but not results; 3, progress and results summary; 5, full report
 [default 2 or as specified using gl.set.verbosity].
 
 @details
Genlight objects assign specimens to populations based on information in the
ind.metadata file provided when the genlight object is first generated.
Often one wishes to subset the data by deleting populations or to amalgamate
populations. This can be done with a pop.recode table with two columns. The
first column is the population assignment in the genlight object, the second
column provides the new assignment.
This function will input an existing reassignment table for editing and
optionally save it as a new table, or if the name of an input table is not
supplied, will generate a table using the population assignments in the
parent genlight object. It will then apply the recodings to the genlight 
object.
When caution needs to be exercised because of the potential for breaking the
'chain of evidence' associated with the samples, recoding individuals using
a recode table (csv) can provide a durable record of the changes.
For SNP genotype data, the function, having deleted populations, optionally 
identifies resultant monomorphic loci or loci with all values missing 
and deletes them. The script also optionally recalculates the
locus metadata as appropriate. The optional deletion of monomorphic loci
and the optional recalculation of locus statistics is not available for
Tag P/A data (SilicoDArT).
Use outpath=getwd() when calling this function to direct
output files to your working directory.
The function returns a dartR genlight object with the new population assignments  
and the recalculated locus metadata.}
}
\value{
A genlight object with the revised population assignments
}
\description{
A function to edit population assignments in a dartR genlight object, or to
create a reassignment table taking the population assignments
from a genlight object, or to edit existing population assignments in
a pop.recode.table. The amended recode table is then applied to the genlight
object.
}
\examples{
#this is an interactive example
if(interactive()){
gl <- gl.edit.recode.pop(testset.gl)
gs <- gl.edit.recode.pop(testset.gs)
}

# See also -------------------
}
\seealso{
\code{\link{gl.recode.pop}}, \code{\link{gl.drop.pop}},
\code{\link{gl.keep.pop}}, \code{\link{gl.merge.pop}},
\code{\link{gl.reassign.pop}}

Other data manipulation: 
\code{\link{gl.define.pop}()},
\code{\link{gl.drop.ind}()},
\code{\link{gl.drop.loc}()},
\code{\link{gl.drop.pop}()},
\code{\link{gl.impute}()},
\code{\link{gl.join}()},
\code{\link{gl.keep.ind}()},
\code{\link{gl.keep.loc}()},
\code{\link{gl.keep.pop}()},
\code{\link{gl.make.recode.ind}()},
\code{\link{gl.merge.pop}()},
\code{\link{gl.reassign.pop}()},
\code{\link{gl.recode.ind}()},
\code{\link{gl.recode.pop}()},
\code{\link{gl.rename.pop}()},
\code{\link{gl.sample}()},
\code{\link{gl.sim.genotypes}()},
\code{\link{gl.sort}()},
\code{\link{gl.subsample.ind}()},
\code{\link{gl.subsample.loc}()}
}
\author{
Custodian: Arthur Georges -- Post to
\url{https://groups.google.com/d/forum/dartr}
}
\concept{data manipulation}
