% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_waterdata_latest_continuous.R
\name{read_waterdata_latest_continuous}
\alias{read_waterdata_latest_continuous}
\title{Get Latest Continuous USGS Water Data}
\usage{
read_waterdata_latest_continuous(
  monitoring_location_id = NA_character_,
  parameter_code = NA_character_,
  properties = NA_character_,
  time_series_id = NA_character_,
  approval_status = NA_character_,
  unit_of_measure = NA_character_,
  qualifier = NA_character_,
  value = NA,
  last_modified = NA_character_,
  skipGeometry = NA,
  time = NA_character_,
  bbox = NA,
  limit = NA,
  convertType = TRUE,
  no_paging = FALSE
)
}
\arguments{
\item{monitoring_location_id}{A unique identifier representing a single monitoring location. This corresponds to the \code{id} field in the \code{monitoring-locations} endpoint. Monitoring location IDs are created by combining the agency code of the agency responsible for the monitoring location (e.g. USGS) with the ID number of the monitoring location (e.g. 02238500), separated by a hyphen (e.g. USGS-02238500).

Multiple monitoring_location_ids can be requested as a character vector.}

\item{parameter_code}{Parameter codes are 5-digit codes used to identify the constituent measured and the units of measure. A complete list of parameter codes and associated groupings can be found at \url{https://api.waterdata.usgs.gov/ogcapi/v0/collections/parameter-codes/items}.

Multiple parameter_codes can be requested as a character vector.}

\item{properties}{A vector of requested columns to be returned from the query.
Available options are:
geometry, latest_continuous_id, time_series_id, monitoring_location_id, parameter_code, statistic_id, time, value, unit_of_measure, approval_status, qualifier, last_modified.
The default (\code{NA}) will return all columns of the data.}

\item{time_series_id}{A unique identifier representing a single time series. This corresponds to the \code{id} field in the \code{time-series-metadata} endpoint.

Multiple time_series_ids can be requested as a character vector.}

\item{approval_status}{Some of the data that you have obtained from this U.S. Geological Survey database may not have received Director's approval.  Any such data values are qualified as provisional and are subject to revision.  Provisional data are released on the condition that neither the USGS nor the United States Government may be held liable for any damages resulting from its use. This field reflects the approval status of each record, and is either "Approved", meaining processing review has been completed and the data is approved for publication, or "Provisional" and subject to revision. For more information about provisional data, go to \url{https://waterdata.usgs.gov/provisional-data-statement/}.}

\item{unit_of_measure}{A human-readable description of the units of measurement associated with an observation.}

\item{qualifier}{This field indicates any qualifiers associated with an observation, for instance if a sensor may have been impacted by ice or if values were estimated.}

\item{value}{The value of the observation. Values are transmitted as strings in the JSON response format in order to preserve precision.}

\item{last_modified}{The last time a record was refreshed in our database. This may happen due to regular operational processes and does not necessarily indicate anything about the measurement has changed.
You can query this field using date-times or intervals, adhering to RFC 3339, or using ISO 8601 duration objects. Intervals may be bounded or half-bounded (double-dots at start or end).
Examples:
\itemize{
\item A date-time: "2018-02-12T23:20:50Z"
\item A bounded interval: "2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"
\item Half-bounded intervals: "2018-02-12T00:00:00Z/.." or "../2018-03-18T12:31:12Z"
\item Duration objects: "P1M" for data from the past month or "PT36H" for the last 36 hours
}

Only features that have a \code{last_modified} that intersects the value of datetime are selected.}

\item{skipGeometry}{This option can be used to skip response geometries for
each feature. The returning object will be a data frame with no spatial
information.}

\item{time}{The date an observation represents. You can query this field using date-times or intervals, adhering to RFC 3339, or using ISO 8601 duration objects. Intervals may be bounded or half-bounded (double-dots at start or end).
Examples:
\itemize{
\item A date-time: "2018-02-12T23:20:50Z"
\item A bounded interval: "2018-02-12T00:00:00Z/2018-03-18T12:31:12Z"
\item Half-bounded intervals: "2018-02-12T00:00:00Z/.." or "../2018-03-18T12:31:12Z"
\item Duration objects: "P1M" for data from the past month or "PT36H" for the last 36 hours
}

Only features that have a \code{time} that intersects the value of datetime are selected. If a feature has multiple temporal properties, it is the decision of the server whether only a single temporal property is used to determine the extent or all relevant temporal properties.

You can also use a vector of length 2: the first value being the starting date,
the second value being the ending date. NA's within the vector indicate a
half-bound date. For example, c("2024-01-01", NA) will return all data starting
at 2024-01-01.}

\item{bbox}{Only features that have a geometry that intersects the bounding
box are selected.The bounding box is provided as four or six numbers, depending
on whether the coordinate reference system includes a vertical axis (height or
depth). Coordinates are assumed to be in crs 4326. The expected format is a numeric
vector structured: c(xmin,ymin,xmax,ymax). Another way to think of it is c(Western-most longitude,
Southern-most latitude, Eastern-most longitude, Northern-most longitude).}

\item{limit}{The optional limit parameter is used to control the subset of the
selected features that should be returned in each page. The maximum allowable
limit is 50000. It may be beneficial to set this number lower if your internet
connection is spotty. The default (\code{NA}) will set the limit to the maximum
allowable limit for the service.}

\item{convertType}{logical, defaults to \code{TRUE}. If \code{TRUE}, the function
will convert the data to dates and qualifier to string vector.}

\item{no_paging}{logical, defaults to \code{FALSE}. If \code{TRUE}, the data will
be requested from a native csv format. This can be dangerous because the
data will cut off at 50,000 rows without indication that more data
is available. Use \code{TRUE} with caution.}
}
\description{
This endpoint provides the most recent observation for each time series of continuous data. Continuous data are collected via automated sensors installed at a monitoring location. They are collected at a high frequency and often at a fixed 15-minute interval. Depending on the specific monitoring location, the data may be transmitted automatically via telemetry and be available on WDFN within minutes of collection, while other times the delivery of data may be delayed if the monitoring location does not have the capacity to automatically transmit data. Continuous data are described by parameter name and parameter code. These data might also be referred to as "instantaneous values" or "IV"
}
\examples{
\dontshow{if (is_dataRetrieval_user()) withAutoprint(\{ # examplesIf}

\donttest{
site <- "USGS-451605097071701"
pcode <- "72019"
uv_data_sf <- read_waterdata_latest_continuous(monitoring_location_id = site,
                              parameter_code = pcode)

uv_data_trim <- read_waterdata_latest_continuous(monitoring_location_id = site,
                          parameter_code = pcode, 
                          properties = c("monitoring_location_id",
                                         "value",
                                         "time"))

uv_data <- read_waterdata_latest_continuous(monitoring_location_id = site,
                           parameter_code = pcode,
                           skipGeometry = TRUE)
                        
uv_data_period <- read_waterdata_latest_continuous(monitoring_location_id = site,
                                  parameter_code = pcode,
                                  time = "P7D")

multi_site <- read_waterdata_latest_continuous(monitoring_location_id =  c("USGS-451605097071701",
                                                          "USGS-14181500"),
                              parameter_code = c("00060", "72019"),
                              skipGeometry = TRUE)

# Only return data that has been modified in last 7 days         
multi_site2 <- read_waterdata_latest_continuous(monitoring_location_id =  c("USGS-451605097071701",
                                                                           "USGS-14181500"),
                                               parameter_code = c("00060", "72019"),
                                               last_modified = "P7D")

}
\dontshow{\}) # examplesIf}
}
