% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interval_position.R
\name{interval_position}
\alias{interval_position}
\alias{int_median}
\alias{int_quantile}
\alias{int_range}
\alias{int_iqr}
\alias{int_mad}
\alias{int_mode}
\title{Position and Scale Measures for Interval Data}
\usage{
int_median(x, var_name, method = "CM", ...)

int_quantile(x, var_name, probs = c(0.25, 0.5, 0.75), method = "CM", ...)

int_range(x, var_name, method = "CM", ...)

int_iqr(x, var_name, method = "CM", ...)

int_mad(x, var_name, method = "CM", ...)

int_mode(x, var_name, method = "CM", breaks = 30, ...)
}
\arguments{
\item{x}{interval-valued data with symbolic_tbl class.}

\item{var_name}{the variable name or the column location (multiple variables are allowed).}

\item{method}{methods to calculate statistics: CM (default), VM, QM, SE, FV, EJD, GQ, SPT.}

\item{...}{additional parameters}

\item{probs}{numeric vector of probabilities with values in [0,1].}

\item{breaks}{number of histogram breaks for mode estimation (default: 30).}
}
\value{
A numeric matrix or value
}
\description{
Functions to compute position and scale statistics for interval-valued data.
}
\details{
These functions provide position and scale measures:
\itemize{
  \item \code{int_median}: Median of interval data
  \item \code{int_quantile}: Quantiles of interval data
  \item \code{int_range}: Range (max - min) of interval data
  \item \code{int_iqr}: Interquartile range (Q3 - Q1)
  \item \code{int_mad}: Median absolute deviation
}
}
\examples{
data(mushroom.int)

# Calculate median
int_median(mushroom.int, var_name = "Pileus.Cap.Width")
int_median(mushroom.int, var_name = 2:3, method = c("CM", "EJD"))

# Calculate quantiles
int_quantile(mushroom.int, var_name = 2, probs = c(0.25, 0.5, 0.75))

# Calculate interquartile range
int_iqr(mushroom.int, var_name = c("Stipe.Length", "Stipe.Thickness"))

# Calculate MAD
int_mad(mushroom.int, var_name = 2:3, method = "CM")
}
\seealso{
int_mean int_var int_median int_quantile
}
\author{
Han-Ming Wu
}
