# counting functions ------------------------------------------------------

#' Number of missing values in a vector.
#'
#' @param x an atomic vector
#'
#' @returns returns a integer scalar
#' @export
#'
#' @examples
#' n_missing(c(1, NA, 3))
n_missing <- function(x) {
  sum(is.na(x))
}

#' Nnumber of non missing values in a vector.
#'
#' @param x an atomic vector
#'
#' @returns scalar integer
#' @export
#'
#' @examples
#' n_no_missing(c(1, NA, 3))
n_no_missing <- function(x) {
  length(x) - sum(is.na(x))
}
