% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pressind.r
\name{pressind}
\alias{pressind}
\title{Function to compute the PRESS statistics of a regression
model .}
\usage{
pressind(model = model)
}
\arguments{
\item{model}{an object having the fitted model.}
}
\value{
The main output is the PRESS statistics
}
\description{
Computes the PRESS (Predicted residual sum of squares)
statistics of a regression model.
}
\details{
The function computes the PRESS based on the Hat matrix
of a previously fitted model.
}
\examples{

#Creates a fake dataframe
set.seed(12)
df <- as.data.frame(cbind(Y=rnorm(30, 30,9), X=rnorm(30, 450,133)))
#fitting a candidate model
mod1 <- lm(Y~X, data=df)
#Using the `pressind` function
pressind(mod1)
}
\references{
\itemize{
\item Myers RH. 1990. Classical and Modern Regression with
Applications. Second Edition. Duxbury Classic Series, Pacific
Grove, CA, USA.
}
}
\author{
Christian Salas-Eljatib.
}
