% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CNode.R
\name{getMNode}
\alias{getMNode}
\alias{getMNode,CNode-method}
\title{Get a reference to a node based on its identifier}
\usage{
getMNode(x, ...)

\S4method{getMNode}{CNode}(x, nodeid)
}
\arguments{
\item{x}{The coordinating node to query for its registered Member Nodes}

\item{...}{(Not yet used)}

\item{nodeid}{The standard identifier string for this node}
}
\value{
the Member Node as an MNode reference, or NULL if not found
}
\description{
Get a reference to a node based on its identifier
}
\details{
For an explanation of DataONE Coordinating Nodes and Member Node
identifiers, see the section \emph{"DataONE Environments"} in the overview vignette
by entering the R command: \code{vignette("v01-dataone-overview")}.
}
\examples{
\dontrun{
cn <- CNode()
mn <- getMNode(cn, "urn:node:KNB")
}
}
\seealso{
\code{\link[=CNode-class]{CNode()}} class description.
}
