% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/formatting.R
\name{normalize_date_ts}
\alias{normalize_date_ts}
\title{Ajuste un objet date_ts dans un format conforme.}
\usage{
normalize_date_ts(date_ts, frequency_ts, test = TRUE)
}
\arguments{
\item{date_ts}{un vecteur numérique, de préférence \code{integer}, au format
\code{AAAA}, \code{c(AAAA, MM)} ou \code{c(AAAA, TT)}}

\item{frequency_ts}{un entier qui vaut \code{4L} (ou \code{4.0}) pour les séries
trimestrielles et \code{12L} (ou \code{12.0}) pour les séries mensuelles.}

\item{test}{un booléen (Default is TRUE)}
}
\value{
En sortie, la fonction retourne une date au même format que l'objet
\code{date_ts} avec la période inclus entre 1 et la fréquence.
}
\description{
Ajuste un objet date_ts dans un format conforme.
}
\details{
Ici le formattage correspond à une réécriture de la date sans
en changer la valeur. Alors que l'objet c(2020L, 12L) désigne le mois de
décembre 2020 et c(2021L, 1L) le mois de janvier 2021, on peut imaginer que
la date_ts c(2021L, 0L) peut aussi représenter le mois de décembre 2020.
Si l'argument \code{test} est mis à FALSE, alors aucun test ne sera effectué sur
les données en entrée.
}
\examples{

# Formattage inchangée
normalize_date_ts(c(2020L, 1L), frequency_ts = 4L) # 1er trimestre de 2020
normalize_date_ts(c(2020L, 8L), frequency_ts = 12L) # Aout 2020

# Retour dans le passé
normalize_date_ts(c(2020L, 0L), frequency_ts = 4L) # 4ème trimestre de 2019
normalize_date_ts(c(2020L, -10L), frequency_ts = 12L) # février 2019

# Avancée dans le futur
normalize_date_ts(c(2020L, 7L), frequency_ts = 4L) # 3ème trimestre de 2021
normalize_date_ts(c(2020L, 13L), frequency_ts = 4L) # janvier 2021

}
