% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zzz-class-model-components.R
\name{generated-quantities}
\alias{generated-quantities}
\alias{generated_quantities}
\title{Generated quantities for diagnostic classification}
\usage{
generated_quantities(loglik = FALSE, probabilities = FALSE, ppmc = FALSE)
}
\arguments{
\item{loglik}{Logical indicating whether log-likelihood should be generated.}

\item{probabilities}{Logical indicating whether class and attribute
proficiency probabilities should be generated.}

\item{ppmc}{Logical indicating whether replicated data sets for
\acronym{PPMCs} should be generated.}
}
\value{
A generated quantities object.
}
\description{
Generated quantities are values that are calculated from model parameters,
but are not directly involved in the model estimation. For example, generated
quantities can be used to simulate data for posterior predictive model checks
(PPMCs; e.g., Gelman et al., 2013).
See details for additional information on each quantity that is available.
}
\details{
The log-likelihood contains respondent-level log-likelihood values. This may
be useful when calculating relative fit indices such as the CV-LOO
(Vehtari et al., 2017) or WAIC (Watanabe, 2010).

The probabilities are primary outputs of interest for respondent-level
results. These quantities include the probability that each respondent
belongs to each class, as well as attribute-level proficiency probabilities
for each respondent.

The PPMCs generate a vector of new item responses based on the parameter
values. That is, the generated quantities are replicated data sets that could
be used to calculate PPMCs.
}
\examples{
generated_quantities(loglik = TRUE)
}
\references{
Gelman, A., Carlin, J. B., Stern, H. S., Dunson, D. B.,
Vehtari, A., & Rubin, D. B. (2013). \emph{Bayesian Data Analysis} (3rd ed.).
Chapman & Hall/CRC. \url{https://sites.stat.columbia.edu/gelman/book/}

Vehtari, A., Gelman, A., & Gabry, J. (2017). Practical Bayesian
model evaluation using leave-one-out cross-validation and WAIC.
\emph{Statistics and Computing, 27}(5), 1413–1432.
\doi{10.1007/s11222-016-9696-4}

Watanabe, S. (2010). Asymptotic equivalence of Bayes cross
validation and widely applicable information criterion in singular learning
theory. \emph{Journal of Machine Learning Research, 11}(116), 3571–3594.
\url{http://jmlr.org/papers/v11/watanabe10a.html}
}
