% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distcov_test2.R
\name{distcov.test}
\alias{distcov.test}
\title{Performs a distance covariance test.}
\usage{
distcov.test(
  X,
  Y,
  method = "permutation",
  b = 499L,
  ln = 20,
  affine = FALSE,
  standardize = FALSE,
  bias.corr = FALSE,
  type.X = "sample",
  type.Y = "sample",
  metr.X = "euclidean",
  metr.Y = "euclidean",
  use = "all",
  return.data = FALSE,
  algorithm = "auto"
)
}
\arguments{
\item{X}{contains either the first sample or its corresponding distance matrix.

In the first case, X can be provided either as a vector (if one-dimensional), a matrix or a data.frame (if two-dimensional or higher). 

In the second case, the input must be a distance matrix corresponding to the sample of interest.

If X is a sample, type.X must be specified as "sample". If X is a distance matrix, type.X must be specified as "distance".}

\item{Y}{see X.}

\item{method}{specifies the type of test that is performed.
 
"permutation" performs a Monte Carlo Permutation test. 

"gamma" performs a test based on a gamma approximation of the test statistic under the null \insertCite{huang2017statistically}{dcortools}. This test tends to be anti-conservative, if the ``real'' p-value is small

"conservative" performs a conservative two-moment approximation \insertCite{berschneider2018complex}{dcortools}.
  
"bb3" performs a  three-moment approximation  \insertCite{berschneider2018complex}{dcortools}. This is the most precise parametric option, but only available with the standard algorithm.

"wildbs1" and "wilbs2" perform wild bootstrap tests \insertCite{chwialkowski2014wild}{dcortools}; experimental at the moment.}

\item{b}{integer; specifies the number of random permutations/bootstrap samples used for the permutation or wild bootstraps tests. Ignored for other tests.}

\item{ln}{numeric; block size parameter for wild bootstrap tests. Ignored for other tests.}

\item{affine}{logical; specifies if the affinely invariant distance covariance \insertCite{dueck2014affinely}{dcortools} should be calculated or not.}

\item{standardize}{logical; specifies if X and Y should be standardized dividing each component by its standard deviations. No effect when affine = TRUE.}

\item{bias.corr}{logical; specifies if the bias corrected version of the sample distance covariance \insertCite{huo2016fast}{dcortools} should be calculated.}

\item{type.X}{For "distance", X is interpreted as a distance matrix. For "sample", X is interpreted as a sample.}

\item{type.Y}{see type.X.}

\item{metr.X}{specifies the metric which should be used to compute the distance matrix for X (ignored when type.X = "distance").

 Options are "euclidean", "discrete", "alpha", "minkowski", "gaussian", "gaussauto", "boundsq" or user-specified metrics (see examples).
 
 For "alpha", "minkowski", "gauss", "gaussauto" and "boundsq", the corresponding parameters are specified via "c(metric, parameter)", c("gaussian", 3) for example uses a Gaussian metric with bandwidth parameter 3; the default parameter is 2 for "minkowski" and "1" for all other metrics.
 
 See \insertCite{lyons2013distance,sejdinovic2013equivalence,bottcher2017detecting;textual}{dcortools} for details.}

\item{metr.Y}{see metr.X.}

\item{use}{specifies how to treat missing values. "complete.obs" excludes NAs, "all" uses all observations.}

\item{return.data}{logical; specifies if the test object should contain the original data.}

\item{algorithm}{specifies the algorithm used for calculating the distance covariance. 

"fast" uses an O(n log n) algorithm if the observations are one-dimensional and metr.X and metr.Y are either "euclidean" or "discrete", see also \insertCite{huo2016fast;textual}{dcortools}. 

"memsave" uses a memory saving version of the standard algorithm with computational complexity O(n^2) but requiring only O(n) memory. 

"standard" uses the classical algorithm. User-specified metrics always use the classical algorithm.

"auto" chooses the best algorithm for the specific setting using a rule of thumb.}
}
\value{
distcov.test object
}
\description{
Performs a distance covariance test.
}
\references{
\insertRef{berschneider2018complex}{dcortools}

\insertRef{bottcher2017detecting}{dcortools}

\insertRef{chwialkowski2014wild}{dcortools}

\insertRef{dueck2014affinely}{dcortools}

\insertRef{huang2017statistically}{dcortools}

\insertRef{huo2016fast}{dcortools}

\insertRef{lyons2013distance}{dcortools}

\insertRef{sejdinovic2013equivalence}{dcortools}

\insertRef{szekely2007}{dcortools}

\insertRef{szekely2009brownian}{dcortools}
}
