% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/decomp_age.R
\name{decomp_age}
\alias{decomp_age}
\title{Title decomp_age}
\usage{
decomp_age(df, method = "arriaga3", age_col, e1, e2, l1, l2, append = TRUE)
}
\arguments{
\item{df}{An outputted life table with columns for age bands, number of persons alive at each age band and expectation of life at each age band}

\item{method}{Methods to use for life expectancy decomposition. Defaults to 'arriaga3'. Current methods available are: 'arriaga3', 'chandrasekaran1', 'chandrasekaran2'.}

\item{age_col}{Column providing ordered age bands with the final age group being an open-ended interval suffxied with '+', e.g. '90+'.. Of factor type.}

\item{e1}{Column name for expectation of life at age group x, in the 1st group of comparison.}

\item{e2}{Column name for expectation of life at age group x, in the 2nd group of comparison.}

\item{l1}{Column name for the proportion of persons alive at age group x, in the 1st group of comparison.}

\item{l2}{Column name for the proportion of persons alive at age group x, in the 2nd group of comparison.}

\item{append}{Whether to append the decomposition columns to the original data frame. Default to TRUE.}
}
\value{
A data frame with attached life expectancy age breakdown decomposition values
}
\description{
Function for performing life expectancy decomposition for age bands
}
