% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/datasets_doc_for_CRAN.R
\docType{data}
\name{Ponerinae_trait_cont_tip_data_10My}
\alias{Ponerinae_trait_cont_tip_data_10My}
\title{Data summarizing the evolution of a fake continuous trait in Ponerinae ants extracted for 10 Mya}
\format{
A list with 4 elements.
}
\usage{
data(Ponerinae_trait_cont_tip_data_10My)
}
\description{
A list containing estimated values for a fake continuous trait mapped on the Ponerinae ant phylogeny,
modeled with \link[geiger:fitContinuous]{geiger::fitContinuous}. This object was obtained with \code{\link[=extract_most_likely_trait_values_for_focal_time]{extract_most_likely_trait_values_for_focal_time()}}
applied on trait evolution data obtained with \code{\link[=prepare_trait_data]{prepare_trait_data()}}.
The phylogeny used is NOT a properly time-calibrated phylogeny. It uses an ill-designed old calibration for illustrative purposes.
}
\details{
A list of four elements containing information on the evolution of a continuous trait in Ponerinae ants extracted for 10 Mya.
\itemize{
\item \verb{$trait_data} Named vector of numerical values. Names are the taxa or internal tipward node ID associated with the values.
Values are the continuous trait data estimated along branches for 10 Mya.
\item \verb{$focal_time} Numerical. Time in the past at which the trait data where extracted.
\item \verb{$trait_data_type} Character string. Record the type of trait data. Here: "continuous".
\item \verb{$contMap} A phylogenetic tree and associated mapping of estimated trait values. It was updated such as the tips correspond to
lineages found 10 Mya (i.e., at the focal time in the past).
}
}
\keyword{datasets}
