#' Get DRI from Individual Participants
#'
#' `get_dri_ind` calculates the DRI for each individual participant at a
#' deliberation
#'
#' @param ic dataframe generated by `get_dri_ic(data)`
#' @param adjusted a logical indicating whether to use the original or adjusted
#' DRI calculation formula
#'
#' @returns tibble with `pnum` as participant number and their respective
#' individual `dri`
#'
#' @export
#' @import dplyr
#' @import tibble
#' @importFrom rlang .data
#'
#' @seealso [get_dri_ic()] to generate `ic` parameter
#' @family IC methods
#'
#' @examples
#'
#' # get post-deliberation (stage_id == 2) data from Zukunft case
#' data <- human_data[human_data$stage_id == 2 & human_data$case == "Zukunft", ]
#'
#' # generate IC
#' ic <- get_dri_ic(data)
#'
#' # get individual DRIs
#' get_dri_ind(ic)
#'
get_dri_ind <- function(ic, adjusted = TRUE) {
  # tracks return value
  dri_ind <- list()

  # iterate through all pnums
  for (pi in union(ic$pnum1, ic$pnum2)) {
    # STEP 1: get data for pnum i
    pi_ic <- ic %>% filter(.data$pnum1 == pi | .data$pnum2 == pi)

    # use DRI formula to calculate DRI
    pi_dri <- get_dri(pi_ic, adjusted)

    # # STEP 2: calculate distance
    # pi_di <- mean(pi_ic$dj)
    #
    # # STEP 3: calculate individual dri
    # lambda <- sqrt(2) / 2
    # pi_dri <- ((-2 * pi_di) + lambda) / lambda
    dri_ind[[length(dri_ind) + 1]] <- tibble(pnum = pi, dri = pi_dri)

  }

  return(bind_rows(dri_ind))

}
