% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dri.R
\name{get_dri}
\alias{get_dri}
\title{Get DRI from a Group of Participants}
\usage{
get_dri(ic, adjusted = TRUE)
}
\arguments{
\item{ic}{dataframe generated by \code{get_dri_ic(data)}}

\item{adjusted}{a logical indicating whether to use the original or adjusted
DRI calculation formula}
}
\value{
the group-level DRI value
}
\description{
\code{get_dri} calculates the deliberation reasoning index (DRI) for a group of
deliberation participants
}
\examples{

# get pre-deliberation (stage_id == 1) data from BEP case
data <- human_data[human_data$stage_id == 1 & human_data$case == "BEP", ]

# calculate IC
ic <- get_dri_ic(data)

# generate DRI
get_dri(ic)

# same as the mean of individual DRIs
mean(get_dri_ind(ic)$dri)

}
\seealso{
\code{\link[=get_dri_ic]{get_dri_ic()}} to generate \code{ic} parameter

Other IC methods: 
\code{\link{get_dri_ind}()}
}
\concept{IC methods}
