% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_dri_alpha.R
\name{get_dri_alpha}
\alias{get_dri_alpha}
\title{Get DRI Cronbach's Alpha}
\usage{
get_dri_alpha(data)
}
\arguments{
\item{data}{the raw DRI survey response data}
}
\value{
a dataframe with \code{alpha_c}, \code{alpha_p}, and \code{alpha_all} with values
of Cronbach's alpha for considerations, policy preferences, and both,
respectively
}
\description{
\code{get_dri_alpha} calculates the internal consistency of DRI survey responses
using Cronbach's alpha
}
\examples{

# get pre-deliberation (stage_id == 1) data from Mayo case
data <- human_data[human_data$stage_id == 1 & human_data$case == "Mayo", ]
get_dri_alpha(data)

}
\seealso{
\link{human_data} for raw survey response data formatting

\code{\link[psych:alpha]{psych::alpha()}} for details on Cronbach's alpha calculation

Other DRI survey methods: 
\code{\link{get_dri_case}()},
\code{\link{get_dri_ic}()}
}
\concept{DRI survey methods}
