% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_dri_ic.R
\name{plot_dri_ic}
\alias{plot_dri_ic}
\title{Plot DRI Intersubjective Consistency (IC)}
\usage{
plot_dri_ic(
  ic,
  title = NA_character_,
  suffix = NA_character_,
  dri = NA_real_,
  caption = NULL
)
}
\arguments{
\item{ic}{dataframe generated by \code{get_dri_ic(data)}}

\item{title}{title of the plot}

\item{suffix}{string to be added after the title separated by \code{:}}

\item{dri}{numeric value generated by \code{get_dri(ic)}; if omitted, \code{get_dri} is
called by default}

\item{caption}{a string to be displayed under the plot}
}
\value{
an IC plot
}
\description{
\code{plot_dri_ic} creates a dot plot of deliberation IC where each dot represents
a pair of participants
}
\examples{

# get post-deliberation (stage_id == 2) data from Zukunft case
data <- human_data[human_data$stage_id == 2 & human_data$case == "Zukunft", ]

# set plot optional parameters
title <- "Case Zukunft"
suffix <- "Post-Deliberation IC Plot"
caption <- "this is an example plot"

# calculate ic
ic <- get_dri_ic(data)

plot_dri_ic(ic, title, suffix, caption = caption)

}
\seealso{
\code{\link[=get_dri_ic]{get_dri_ic()}} for how to generate the \code{ic} parameter

\code{\link[=get_dri]{get_dri()}} for how to generate the \code{dri} parameter
}
