% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/as_dwc.R
\name{as_dwc}
\alias{as_dwc}
\title{Rename Columns using Darwin Core Standard Terms}
\usage{
as_dwc(dwc, data, terms)
}
\arguments{
\item{dwc}{a list of standard terms and definitions created using \code{\link[=get_dwc]{get_dwc()}}.}

\item{data}{a \link[tibble:tbl_df-class]{tbl_df}.}

\item{terms}{a vector or list of terms to be used as replacement.}
}
\value{
an object of class \link[tibble:tbl_df-class]{tbl_df}.
}
\description{
\code{as_dwc()} rename columns in a \link[tibble:tbl_df-class]{tbl_df} using a vector of terms defined by
Darwin Core Standard.
}
\details{
\code{as_dwc()} will replace current column names by the ones defined in \code{terms}. For each
column in \code{data}, Darwin Core equivalent terms must be informed in the same order
by the user. If \code{terms} and column names do not match in length or if \code{terms} used
are not found in Darwin Core standard, an error will be printed on \code{Console}.
}
\examples{

# get dwc terms and definitions
dwc <- get_dwc(type = "simple")

# create a data frame with sample metadata
my_df <- tibble::tibble(
  species = c("sp1", "sp2", "sp3"),
  location = c("loc1", "loc2", "loc3"),
  voucher = c("M01", "M02", "M03"),
  collector = c("John", "Robert", "David")
)

# rename columns
as_dwc(dwc, my_df, terms = c("scientificName", "locality", "catalogNumber", "recordedBy"))

}
\author{
Pedro S. Bittencourt, Rupert A. Collins.
}
