% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_stat.R
\name{sum_stat}
\alias{sum_stat}
\title{Summarize Continuous and Categorical Variables with Optional Grouping}
\usage{
sum_stat(
  data,
  by = NULL,
  statistic = "mean_sd",
  percent = "col",
  ci = FALSE,
  conf = 0.95,
  report = FALSE
)
}
\arguments{
\item{data}{A data.frame or tibble containing the variables to summarize.}

\item{by}{Optional. A single variable name (as string) to group the summary by.}

\item{statistic}{Character string indicating how to summarize continuous variables. Options are \code{"mean_sd"} (default) or \code{"med_iqr"}.}

\item{percent}{Character string specifying how percentages should be calculated for categorical variables: \code{"col"} (column-wise), \code{"row"} (row-wise), or \code{"none"} (no percentage). Default is \code{"col"}.}

\item{ci}{Logical. If TRUE, 95\% confidence intervals are included in the summary for continuous and categorical variables. Default is FALSE.}

\item{conf}{Numeric. Confidence level for CI calculation (between 0 and 1). Default is 0.95.}

\item{report}{Logical. If TRUE, prints a narrative summary of the variables. Default is TRUE.}
}
\value{
A \code{flextable} object displaying the summarized variables, optionally including confidence intervals and group comparisons.
}
\description{
\code{sum_stat} provides a summary of both continuous and categorical variables in a dataset.
Continuous variables can be summarized using mean (SD) or median (IQR), optionally with 95\% confidence intervals.
Categorical variables are summarized as counts and percentages, optionally with confidence intervals.
Summaries can also be generated by a grouping variable, and a narrative interpretation is optionally printed.
}
\examples{
# Basic summary of iris dataset
sum_stat(iris, ci = FALSE, report = TRUE)

# Summary of CO2 dataset by 'Treatment' with CI
sum_stat(CO2, by = "Treatment", ci = TRUE, report = TRUE, percent = "row")
}
