% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/option.R
\name{show_scenario}
\alias{show_scenario}
\title{Plot a Bar Chart for a Single Scenario}
\usage{
show_scenario(scenario, tree, label_y = TRUE, modify_par = TRUE)
}
\arguments{
\item{scenario}{Scenario data to visualize.}

\item{tree}{Associated \code{Tree} object providing attribute details.}

\item{label_y}{\code{Logical} value indicating whether to label the Y-axis
(default is \code{TRUE}).}

\item{modify_par}{\code{Logical} value to decide if graphical parameters
should be modified (default is \code{TRUE}).}
}
\value{
No return value, called for side effects
}
\description{
Visualizes the attribute values of a provided scenario. For each attribute, a
bar is plotted, and the maximum possible value is highlighted.
}
\examples{
tree <- dexisensitivity::masc2
option <- create_options(tree, num_options=1, seed = 42)
scenario <- evaluate_scenario(tree, option)
show_scenario(as.matrix(scenario), tree = tree, label_y = TRUE)

}
\seealso{
\code{\link{evaluate_scenario}}
}
