% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sensitivity_index.R
\name{si_dexi}
\alias{si_dexi}
\title{Compute Sensitivity Index (SI) for Decision Tree}
\usage{
si_dexi(
  tree,
  file_name = "SI_out.csv",
  is_file = FALSE,
  avoid_repetition = FALSE
)
}
\arguments{
\item{tree}{A \code{Tree} object on which the analysis will be executed.}

\item{file_name}{\code{character} designating the filename to store the SI.
Default is "SI_out.csv".}

\item{is_file}{\code{logical} determining whether to save the SI results to a
file. Defaults to FALSE}

\item{avoid_repetition}{\code{logical} indicating if repeated nodes should be
disregarded. Defaults to FALSE.}
}
\value{
A list containing the Sensitivity Indices for every node in the tree.
}
\description{
Computes the Sensitivity Index (SI) for each node within a specified decision
tree.
}
\examples{
tree <- dexisensitivity::masc2
sensitivity_index <- si_dexi(tree)
sensitivity_index

}
