% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{news}
\alias{news}
\alias{news.dfm}
\alias{print.dfm_news}
\alias{print.dfm_news_list}
\alias{$.dfm_news_list}
\alias{[[.dfm_news_list}
\alias{[.dfm_news_list}
\alias{as.data.frame.dfm_news_list}
\title{News Decomposition}
\usage{
news(object, ...)

\method{news}{dfm}(
  object,
  comparison,
  t.fcst = nrow(object$X_imp),
  target.vars = NULL,
  series = NULL,
  standardized = FALSE,
  ...
)

\method{print}{dfm_news}(x, digits = 4L, ...)

\method{print}{dfm_news_list}(x, digits = 4L, ...)

\method{$}{dfm_news_list}(x, name)

\method{[[}{dfm_news_list}(x, i)

\method{[}{dfm_news_list}(x, i)

\method{as.data.frame}{dfm_news_list}(x, ...)
}
\arguments{
\item{object}{a \code{dfm} object for the old vintage.}

\item{\dots}{not used.}

\item{comparison}{a \code{dfm} object or a new dataset for the updated vintage.}

\item{t.fcst}{integer. Forecast target time index.}

\item{target.vars}{Integer or character identifying target variables. Defaults to all variables.}

\item{series}{optional character vector for naming variables.}

\item{standardized}{logical. Return results on standardized scale?}

\item{x}{an object of class 'dfm_news' or 'dfm_news_list'.}

\item{digits}{integer. Number of digits to print.}

\item{name}{character. Element name.}

\item{i}{index. Element position or name.}
}
\value{
For a single target, a \code{dfm_news} object with elements:
\itemize{
\item \code{y_old}: old forecast for the target variable at \code{t.fcst}.
\item \code{y_new}: new forecast for the target variable at \code{t.fcst}.
\item \code{news_df}: data frame with one row per series and columns:
\itemize{
\item \code{series}: series name.
\item \code{actual}: actual release (if any).
\item \code{forecast}: old-vintage forecast of the release.
\item \code{news}: total innovation for the series on the output scale. If there is a
single release, \code{news} equals \code{actual - forecast}. With multiple releases,
\code{news} aggregates those innovations for the series.
\item \code{gain}: effective weight on \code{news} such that \code{impact = news * gain}
(on the output scale).
\item \code{gain_std}: effective weight on the standardized innovations.
\item \code{impact}: contribution of the series to the target revision.
}
}
If \code{target.vars} selects multiple targets, a \code{dfm_news_list} object is returned,
where each element is a \code{dfm_news} object and list names correspond to targets.
}
\description{
Compute the Banbura and Modugno (2014) news decomposition of forecast updates.
Given an old vintage and an updated vintage, the function decomposes the
forecast revision at \code{t.fcst} into contributions from new releases.
}
\details{
Let \eqn{y_t^{old}} and \eqn{y_t^{new}} be the old and new forecasts of a target
series at \eqn{t = t_{fcst}}. For each new release \eqn{i} (a previously missing
observation that becomes observed), the innovation is
\deqn{\nu_i = x_i^{new} - \hat{x}_i^{old},}
where \eqn{\hat{x}_i^{old}} is the smoothed estimate from the old vintage.
The revision is decomposed as
\deqn{y_t^{new} - y_t^{old} = \sum_i g_i \nu_i,}
with gain weights computed from Kalman smoother covariances:
\deqn{g = \sigma_y C_y P_1 P_2^{-1}.}
Here \eqn{\sigma_y} is the target series standard deviation, \eqn{C_y} is the
loading row for the target series, \eqn{P_1} collects cross-covariances between
the target and each news item, and \eqn{P_2} is the covariance matrix of the
news items (including measurement error where appropriate). See Section 2.3 and
Appendix D in Banbura and Modugno (2014).

The function uses the system matrices and scaling from the new vintage. The old
data are re-standardized to the new-vintage scale before smoothing so that
innovations and gains are computed on a consistent scale. Set
\code{standardized = FALSE} to report results on the original data scale.
}
\note{
This implementation is translated from the original MATLAB codes and is
consistent with the BM2014 news decomposition formulas.
If the model was estimated with \code{max.missing < 1} and
\code{na.rm.method = "LE"} in \code{\link{tsnarmimp}} (called by \code{DFM()}), leading or trailing rows with many missing values
may be removed by \code{DFM()}. If old and new vintages are both dfm objects, and they drop different rows,
then \code{t.fcst} can become out of bounds. When \code{comparison} is provided
as raw data, \code{news()} drops \code{object$rm.rows} from the new dataset (if present) and
forces \code{max.missing = 1} for the re-estimation call to keep row alignment.
To avoid issues, estimate both vintages with \code{max.missing = 1}.
For mixed-frequency or idiosyncratic AR(1) models, \code{news()} relies on the full
state-space matrices stored in \code{dfm$ss_full}.
}
\examples{
\donttest{
# (1) Monthly DFM example
X <- collapse::qM(BM14_M)[, BM14_Models$medium[BM14_Models$freq == "M"]]
X_old <- X
# Creating earlier vintage
X_old[nrow(X) - 1, sample(which(is.finite(X[nrow(X) - 1, ]) & is.na(X[nrow(X), ])), 5)] <- NA
X_old[nrow(X), sample(which(is.finite(X[nrow(X), ])), 5)] <- NA
# Estimating DFM
dfm <- DFM(X_old, r = 2, p = 2, em.method = "none")
# News computation (second DFM fit internally with same settings and rows)
res <- news(dfm, X, target.vars = c("ip_tot_cstr", "orders", "urx"))
# See results
print(res)
head(res$news_df)

# (2) MQ nowcast of GDP (idio.ar1 = FALSE for speed)
library(magrittr)
library(xts)
# Creating MQ dataset
BM14 <- merge(BM14_M, BM14_Q)
BM14[, BM14_Models$log_trans] \%<>\% log()
BM14[, BM14_Models$freq == "M"] \%<>\% diff()
BM14[, BM14_Models$freq == "Q"] \%<>\% diff(3)
X <- BM14[-1, BM14_Models$small]
quarterly.vars <- BM14_Models$series[BM14_Models$small & BM14_Models$freq == "Q"]
# Creating earlier vintage
X_old <- X
X_old[355, "ip_tot_cstr"] <- NA
X_old[355, "new_cars"] <- NA
X_old[356, "new_cars"] <- NA
X_old[356, "pms_pmi"] <- NA
X_old[356, "euro325"] <- NA
X_old[356, "capacity"] <- NA
# Estimating DFM
dfm <- DFM(X_old, r = 2, p = 2, quarterly.vars = quarterly.vars, max.missing = 1)
# News computation (second DFM fit internally with same settings and rows)
res_mq <- news(dfm, X, t.fcst = 356, target.vars = "gdp")
# See results
print(res_mq)
head(res_mq$news_df)
}

}
\references{
Banbura, M., & Modugno, M. (2014). Maximum likelihood estimation of factor
models on datasets with arbitrary pattern of missing data.
\emph{Journal of Applied Econometrics, 29}(1), 133-160.
}
\seealso{
\link{dfms-package}
}
