% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/querycount.R
\name{HEQueryCountWorker}
\alias{HEQueryCountWorker}
\title{Create a homomorphic computation query count worker object for use with master objects generated by \code{\link[=HEQueryCountMaster]{HEQueryCountMaster()}}}
\description{
\code{HEQueryCountWorker} objects are worker objects at each site of
a distributed query count model computation using homomorphic encryption
}
\seealso{
\code{\link[=HEQueryCountMaster]{HEQueryCountMaster()}} which goes hand-in-hand with this object
}
\section{Super class}{
\code{\link[distcomp:QueryCountWorker]{distcomp::QueryCountWorker}} -> \code{HEQueryCountWorker}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{pubkey}}{the master's public key visible to everyone}

\item{\code{den}}{the denominator for rational arithmetic}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-HEQueryCountWorker-new}{\code{HEQueryCountWorker$new()}}
\item \href{#method-HEQueryCountWorker-setParams}{\code{HEQueryCountWorker$setParams()}}
\item \href{#method-HEQueryCountWorker-queryCount}{\code{HEQueryCountWorker$queryCount()}}
\item \href{#method-HEQueryCountWorker-clone}{\code{HEQueryCountWorker$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="distcomp" data-topic="QueryCountWorker" data-id="getStateful"><a href='../../distcomp/html/QueryCountWorker.html#method-QueryCountWorker-getStateful'><code>distcomp::QueryCountWorker$getStateful()</code></a></span></li>
<li><span class="pkg-link" data-pkg="distcomp" data-topic="QueryCountWorker" data-id="kosher"><a href='../../distcomp/html/QueryCountWorker.html#method-QueryCountWorker-kosher'><code>distcomp::QueryCountWorker$kosher()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountWorker-new"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountWorker-new}{}}}
\subsection{Method \code{new()}}{
Create a new \code{HEQueryMaster} object.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountWorker$new(
  defn,
  data,
  pubkey_bits = NULL,
  pubkey_n = NULL,
  den_bits = NULL
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{defn}}{the computation definition}

\item{\code{data}}{the data which is usually the list of sites}

\item{\code{pubkey_bits}}{the number of bits in public key}

\item{\code{pubkey_n}}{the \code{n} for the public key}

\item{\code{den_bits}}{the number of bits in the denominator (power of 2) used in rational approximations}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
a new \code{HEQueryMaster} object
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountWorker-setParams"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountWorker-setParams}{}}}
\subsection{Method \code{setParams()}}{
Set some parameters for homomorphic computations
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountWorker$setParams(pubkey_bits, pubkey_n, den_bits)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{pubkey_bits}}{the number of bits in public key}

\item{\code{pubkey_n}}{the \code{n} for the public key}

\item{\code{den_bits}}{the number of bits in the denominator (power of 2) used in rational approximations}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountWorker-queryCount"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountWorker-queryCount}{}}}
\subsection{Method \code{queryCount()}}{
Run the query count on local data and return the appropriate encrypted result to the party
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountWorker$queryCount(partyNumber, token)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{partyNumber}}{the NCP party number (1 or 2)}

\item{\code{token}}{a token to use for identifying parts of the same computation for NCP1 and NCP2}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
the count as a list of encrypted items with components \code{int} and \code{frac}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-HEQueryCountWorker-clone"></a>}}
\if{latex}{\out{\hypertarget{method-HEQueryCountWorker-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HEQueryCountWorker$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
