% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/occ_avg_dist.R
\name{occ.avg.dist}
\alias{occ.avg.dist}
\title{Average pairwise distance between occurrences by species}
\usage{
occ.avg.dist(df, species_col = "species", lon_col = "lon", lat_col = "lat")
}
\arguments{
\item{df}{A data.frame (or tibble) containing species names and coordinates.}

\item{species_col}{Character. Column name containing species names. Default "species".}

\item{lon_col}{Character. Column name containing longitudes (decimal degrees). Default "lon".}

\item{lat_col}{Character. Column name containing latitudes (decimal degrees). Default "lat".}
}
\value{
A data.frame with columns:
\itemize{
\item species: unique species names
\item avg_distance_m: mean pairwise distance in meters
}
}
\description{
Compute the mean of all unique pairwise great-circle distances between
occurrence records for each species, using longitude/latitude coordinates
(EPSG:4326). Distances are computed with sf::st_distance().
}
\details{
For each species, the function:
\itemize{
\item Filters out rows with missing species or coordinates
\item Converts lon/lat to an sf point object with CRS = 4326
\item Builds a full distance matrix within the species
\item Extracts the upper triangle (unique pairs) and averages distances
}

Species with fewer than 2 valid records return NA.
}
\examples{
\donttest{
library(dplyr)
library(sf)

# Create example occurrence data for 3 species
occurrences <- tibble(
  species = c(
    rep("Species_A", 4),
    rep("Species_B", 5),
    rep("Species_C", 2)
  ),
  lon = c(
    # Species A: widespread across Brazil
    -43.2, -47.9, -38.5, -51.2,
    # Species B: clustered in southeast
    -43.9, -44.1, -43.7, -44.3, -43.8,
    # Species C: only 2 points
    -45.0, -46.0
  ),
  lat = c(
    # Species A
    -22.9, -15.8, -12.9, -30.0,
    # Species B
    -19.9, -20.1, -19.8, -20.3, -20.0,
    # Species C
    -23.5, -24.0
  )
)

# Calculate average pairwise distances
result <- occ.avg.dist(occurrences)
result
}

}
