% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/expect_snapshot_doc.R
\name{expect_snapshot_flextables}
\alias{expect_snapshot_flextables}
\title{Visual snapshot test for flextable object(s)}
\usage{
expect_snapshot_flextables(x, name, res = 200, ncol = NULL, tolerance = 0.001)
}
\arguments{
\item{x}{a flextable object or a list containing flextable objects.}

\item{name}{a unique string used as the snapshot file name
(\verb{<name>.png}). Must be unique across the test file.}

\item{res}{resolution in DPI, default 200.}

\item{ncol}{number of images per row in the composite when \code{x}
is a list (default \code{NULL}, one image per row).}

\item{tolerance}{ratio of different pixels allowed, default 0.001.}
}
\value{
The result of \code{\link[=expect_snapshot_doc]{expect_snapshot_doc()}}.
}
\description{
Renders flextable objects to PNG with
\code{\link[flextable:save_as_image]{flextable::save_as_image()}} and compares against a reference
snapshot using \code{\link[=expect_snapshot_doc]{expect_snapshot_doc()}}.

When \code{x} is a list of flextable objects, individual renderings are
assembled into a single composite image via \code{images_to_miniature()}.
By default each table occupies its own row; use \code{ncol} to arrange
several tables per row. The snapshot is always a single file
named \verb{<name>.png}, stored in testthat's \verb{_snaps} directory.

If a table fails to render, its slot is replaced by a blank white
rectangle (200 x 50 px), making the failure visible in the diff.

On the first run the reference snapshot is created and the
test is reported as a new snapshot. Subsequent runs compare
the current rendering against the stored reference.
}
