% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/anova.cca0.R
\name{anova.cca0}
\alias{anova.cca0}
\title{Permutation Test for canonical correspondence analysis}
\usage{
\method{anova}{cca0}(
  object,
  ...,
  permutations = 999,
  by = c("omnibus", "axis"),
  n_axes = "all",
  max_axis = 10
)
}
\arguments{
\item{object}{an object from \code{\link{dc_CA}}.}

\item{...}{unused.}

\item{permutations}{a list of control values for the permutations as
returned by the function \code{\link[permute]{how}}, or the number of 
permutations required (default 999), or a permutation matrix where each row
gives the permuted indices.}

\item{by}{character \code{"axis"} which sets the test statistic to the
first eigenvalue of the RDA model. Default: \code{NULL} which sets the test
statistic to the weighted variance fitted by the predictors
(=sum of all constrained eigenvalues). The default is quicker 
computationally as it avoids computation of an svd of permuted data sets.}

\item{n_axes}{number of axes used in the test statistic (default: \code{"all"}). 
Example, the test statistic is the sum of the first two eigenvalues, 
if \code{n_axes=2}. With a numeric \code{n_axes} 
and model \code{~X + Condition(Z)}, the residuals of \code{X} 
with respect to \code{Z} are permuted with a test statistic equal to
the sum of the first \code{n_axes} eigenvalues of the fitted \code{Y}
in the model \code{Y ~ X + Z}, with \code{Y} the response in the model.
In the default \code{"all"}, the test statistic is all eigenvalues of the 
model \code{Y ~ X|Z}, \emph{i.e.} the effects of \code{X} after adjustment
for the effects on \code{Y} of \code{Z}.
If \code{by = "axis"}, the setting of \code{n_axes} is ignored.}

\item{max_axis}{maximum number of axes to test if \code{by = "axis"}.}
}
\value{
A list with two elements with names \code{table} and \code{eigenvalues}.
The \code{table} is as from \code{\link[vegan]{anova.cca}} and 
\code{eigenvalues} gives the CCA eigenvalues.
}
\description{
\code{anova.cca0} performs residual predictor permutation for cca0,
which is robust against differences in the 
weights (ter Braak & te Beest, 2022). The arguments of the function are 
similar to those of \code{\link[vegan]{anova.cca}}, but more restricted.
}
\details{
The algorithm is based on published R-code for residual predictor 
permutation in canonical correspondence analysis (ter Braak & te Beest, 2022), 
but using QR-decomposition instead of ad-hoc least-squares functions.

Note that \code{anova.cca0} is much slower than \code{\link[vegan]{anova.cca}}. 

As \code{\link[vegan]{anova.cca}} is implemented in lower level language,
it is difficult to see what it implements.
In simulations (with and without \code{Condition()} ) 
\code{\link[vegan]{anova.cca}} gives results that are very similar
to residual predictor permutation (RPP),
but, with \code{by = "axis"}, it can be conservative 
and is then less powerful than RPP (as tested with vegan 2.6-8).
}
\examples{
data("dune_trait_env")

# rownames are carried forward in results
rownames(dune_trait_env$comm) <- dune_trait_env$comm$Sites
abun <- dune_trait_env$comm[, -1]  # must delete "Sites"

mod <- cca0(formula = abun ~ A1 + Moist + Mag + Use + Manure,
            data = dune_trait_env$envir)

mod # Proportions equal to those Canoco 5.15

scores(mod, which_cor = c("A1", "X_lot"), display = "cor")

set.seed(123)
anova(mod)
anova(mod, by = "axis")

mod2 <- vegan::cca(abun ~ A1 + Moist + Mag + Use + Manure,
                   data = dune_trait_env$envir)
anova(mod2, by = "axis")

dat <- dune_trait_env$envir
dat$Mag <- "SF"
predict(mod, type = "lc", newdata = dat)
}
\references{
ter Braak, C.J.F. & te Beest, D.E. (2022).
Testing environmental effects on taxonomic composition with canonical
correspondence analysis: alternative permutation tests are not equal. 
Environmental and Ecological Statistics. 29 (4), 849-868.
 \doi{10.1007/s10651-022-00545-4}
}
