% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TimeTreesFunctions.R
\name{buildBeast}
\alias{buildBeast}
\title{Read in a directory from a BEAST run. Runs treeannotator and loganalyser.}
\usage{
buildBeast(
  data,
  beast,
  time,
  template,
  dir,
  id,
  mcmc_length = 1e+06,
  resume_clones = NULL,
  trait = NULL,
  asr = FALSE,
  full_posterior = FALSE,
  log_every = "auto",
  include_germline = TRUE,
  nproc = 1,
  quiet = 0,
  burnin = 10,
  low_ram = TRUE,
  germline_range = c(-10000, 10000),
  java = TRUE,
  seed = NULL,
  log_target = 10000,
  trees = NULL,
  tree_states = FALSE,
  start_edge_length = 100,
  start_date = NULL,
  max_start_date = NULL,
  ...
)
}
\arguments{
\item{data}{a list of \code{airrClone} objects}

\item{beast}{location of beast binary directory (beast/bin)}

\item{time}{Name of sample time column}

\item{template}{XML template}

\item{dir}{directory where temporary files will be placed.}

\item{id}{unique identifer for this analysis}

\item{mcmc_length}{Number of MCMC steps}

\item{resume_clones}{Clones to resume for \code{mcmc_length} more steps}

\item{trait}{Trait column used}

\item{asr}{Log ancestral sequences?}

\item{full_posterior}{Read un full distribution of parameters and trees?}

\item{log_every}{Frequency of states logged. \code{auto} will divide mcmc_length by log_target}

\item{include_germline}{Include germline in analysis?}

\item{nproc}{Number of cores for parallelization. Uses at most 1 core per tree.}

\item{quiet}{Amount of rubbish to print to console}

\item{burnin}{Burnin percent (default 10)}

\item{low_ram}{run with less memory (slightly slower)}

\item{germline_range}{Possible date range of germline tip}

\item{java}{Use the -java flag for BEAST run}

\item{seed}{Use specified seeed for the -seed option for BEAST}

\item{log_target}{Target number of samples over \code{mcmc_length}}

\item{trees}{optional list of starting trees, either phylo objects or newick strings}

\item{tree_states}{Use \code{states} vector for starting tree}

\item{start_edge_length}{edge length to use for all branches in starting tree}

\item{start_date}{Starting date of time tree if desired}

\item{max_start_date}{Maximum starting date of time tree if desired}

\item{...}{Additional arguments for XML writing functions}
}
\value{
The input clones tibble with an additional column for the bootstrap replicate trees.
}
\description{
Read in a directory from a BEAST run. Runs treeannotator and loganalyser.
}
\seealso{
\link{getTimeTrees}
}
