% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_fun.R
\name{plot_fn}
\alias{plot_fn}
\title{A function to plot a plot}
\usage{
plot_fn(
  x = NA,
  y = 1,
  A = TRUE,
  B = FALSE,
  C = TRUE,
  D = FALSE,
  E = FALSE,
  F = FALSE,
  f = c(rev(pal_seeblau), "white", pal_pinky),
  g = "white"
)
}
\arguments{
\item{x}{Numeric (integer > 0). 
Default: \code{x = NA}.}

\item{y}{Numeric (double).
Default: \code{y = 1}.}

\item{A}{Boolean. 
Default: \code{A = TRUE}.}

\item{B}{Boolean. 
Default: \code{B = FALSE}.}

\item{C}{Boolean. 
Default: \code{C = TRUE}.}

\item{D}{Boolean. 
Default: \code{D = FALSE}.}

\item{E}{Boolean. 
Default: \code{E = FALSE}.}

\item{F}{Boolean. 
Default: \code{F = FALSE}.}

\item{f}{A color palette (as a vector). 
Default: \code{f = c(rev(pal_seeblau), "white", pal_pinky)}. 
Note: Using colors of the \code{unikn} package by default.}

\item{g}{A color (e.g., a color name, as a character). 
Default: \code{g = "white"}.}
}
\description{
\code{plot_fn} is a function that uses parameters for plotting a plot.
}
\details{
\code{plot_fn} is deliberately kept cryptic and obscure to illustrate 
how function parameters can be explored. 

\code{plot_fn} also shows that brevity in argument names should not 
come at the expense of clarity. In fact, transparent argument names 
are absolutely essential for understanding and using a function. 

\code{plot_fn} currently requires \code{pal_seeblau} and 
\code{pal_pinky} (from the \strong{unikn} package) for its default colors.
}
\examples{
# Basics: 
plot_fn()

# Exploring options: 
plot_fn(x = 2, A = TRUE)
plot_fn(x = 3, A = FALSE, E = TRUE)
plot_fn(x = 4, A = TRUE,  B = TRUE, D = TRUE)
plot_fn(x = 5, A = FALSE, B = TRUE, E = TRUE, f = c("black", "white", "gold"))
plot_fn(x = 7, A = TRUE,  B = TRUE, F = TRUE, f = c("steelblue", "white", "forestgreen"))

}
\seealso{
\code{\link{plot_fun}} for a related function; 
\code{\link{pal_ds4psy}} for a color palette.

Other plot functions: 
\code{\link{plot_charmap}()},
\code{\link{plot_chars}()},
\code{\link{plot_circ_points}()},
\code{\link{plot_fun}()},
\code{\link{plot_n}()},
\code{\link{plot_text}()},
\code{\link{plot_tiles}()},
\code{\link{theme_clean}()},
\code{\link{theme_ds4psy}()},
\code{\link{theme_empty}()}
}
\concept{plot functions}
