% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.asNumeric.R
\name{ds.asNumeric}
\alias{ds.asNumeric}
\title{Converts a server-side R object into a numeric class}
\usage{
ds.asNumeric(x.name = NULL, newobj = NULL, datasources = NULL)
}
\arguments{
\item{x.name}{a character string providing the name of the input object to be coerced to 
a numeric.}

\item{newobj}{a character string that provides the name for the output object
that is stored on the data servers. Default \code{asnumeric.newobj}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.asNumeric} returns the R object converted into a numeric class
that is written to the server-side. Also, two validity messages are returned 
to the client-side indicating the name of the \code{newobj} which 
has been created in each data source and if 
it is in a valid form.
}
\description{
Coerces an R object into a numeric class. 
This function is based on the native R function \code{as.numeric}.
}
\details{
This function is based on the native R function \code{as.numeric}.
However, it behaves differently with some specific classes of variables. For example, if the input 
object is of class factor, it first converts its values into characters and then convert those to
numerics. This behaviour is important for the case where the input object is of class factor having
numbers as levels. In that case, the native R 
\code{as.numeric} function returns the underlying level codes and not the values as numbers. 
For example \code{as.numeric} in R converts the factor vector: \cr
0 1 1 2 1 0 1 0 2 2 2 1 \cr
Levels: 0 1 2 \cr
to the following numeric vector:
1 2 2 3 2 1 2 1 3 3 3 2 \cr
In contrast DataSHIELD converts an input factor with numeric 
levels to its original numeric values.

Server function called: \code{asNumericDS}
}
\examples{
\dontrun{
  ## Version 6, for version 5 see the Wiki
  
  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  
  # Converting the R object into a numeric class
  ds.asNumeric(x.name = "D$LAB_TSC",
                  newobj = "num.obj",
                  datasources = connections[1]) #only the first Opal server is used ("study1")
  ds.class(x = "num.obj", datasources = connections[1]) 
                
  # Clear the Datashield R sessions and logout                 
  datashield.logout(connections) 
  
}   
}
\author{
DataSHIELD Development Team
}
