% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.list.R
\name{ds.list}
\alias{ds.list}
\title{Constructs a list of objects in the server-side}
\usage{
ds.list(x = NULL, newobj = NULL, datasources = NULL)
}
\arguments{
\item{x}{a character string specifying the names of the objects to coerce into a list.}

\item{newobj}{a character string that provides the name for the output variable 
that is stored on the data servers. Default \code{list.newobj}.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.list} returns a list of objects for each study that is stored on the server-side.
}
\description{
This is similar to the R function \code{list}.
}
\details{
If the objects to coerce into a list are for example vectors held in a matrix
or a data frame the names of the elements in the list are the names of columns.

Server function called: \code{listDS}
}
\examples{
\dontrun{
  ## Version 6, for version 5 see the Wiki
  
  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  
 # combine the 'LAB_TSC' and 'LAB_HDL' variables into a list
 myobjects <- c('D$LAB_TSC', 'D$LAB_HDL')
 ds.list(x = myobjects,
         newobj = "new.list",
         datasources = connections)
  
  # clear the Datashield R sessions and logout
  datashield.logout(connections)
}

}
\author{
DataSHIELD Development Team
}
