% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ds.metadata.R
\name{ds.metadata}
\alias{ds.metadata}
\title{Gets the metadata associated with a variable held on the server}
\usage{
ds.metadata(x = NULL, datasources = NULL)
}
\arguments{
\item{x}{a character string specifying the name of the object.}

\item{datasources}{a list of \code{\link[DSI]{DSConnection-class}} 
objects obtained after login. If the \code{datasources} argument is not specified
the default set of connections will be used: see \code{\link[DSI]{datashield.connections_default}}.}
}
\value{
\code{ds.metadata} returns to the client-side the metadata of associated to an object
held at the server.
}
\description{
This function gets the metadata of a variable
stored on the server.
}
\details{
Server function \code{metadataDS} is called examines the attributes associated with the variable
which are non-disclosive.
}
\examples{
\dontrun{

  # connecting to the Opal servers

  require('DSI')
  require('DSOpal')
  require('dsBaseClient')

  builder <- DSI::newDSLoginBuilder()
  builder$append(server = "study1", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM1", driver = "OpalDriver")
  builder$append(server = "study2", 
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM2", driver = "OpalDriver")
  builder$append(server = "study3",
                 url = "http://192.168.56.100:8080/", 
                 user = "administrator", password = "datashield_test&", 
                 table = "CNSIM.CNSIM3", driver = "OpalDriver")
  logindata <- builder$build()
  
  connections <- DSI::datashield.login(logins = logindata, assign = TRUE, symbol = "D") 
  
  # Example 1: Get the metadata associated with variable 'D'
  ds.metadata(x = 'D$LAB_TSC', datasources = connections)

  # clear the Datashield R sessions and logout
  DSI::datashield.logout(connections)
}

}
\author{
Stuart Wheater, DataSHIELD Development Team
}
