#-------------------------------------------------------------------------------
# Copyright (c) 2019-2022 University of Newcastle upon Tyne. All rights reserved.
# Copyright (c) 2022-2025 Arjuna Technologies, Newcastle upon Tyne. All rights reserved.
#
# This program and the accompanying materials
# are made available under the terms of the GNU Public License v3.0.
#
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <http://www.gnu.org/licenses/>.
#-------------------------------------------------------------------------------

#
# Set up
#

# context("CLUSTER_INT::datachk::setup")

connect.studies.dataset.cluster.int(list("idSurgery", "trtGrp", "intSurgery", "nDoctors", "idDoctor", "intDoctor", "nPatients", "Male", "age", "BMI", "diabetes", "incid_rate", "private"))

test_that("setup", {
    ds_expect_variables(c("D"))
})

#
# Tests
#

# context("CLUSTER_INT::datachk")
test_that("Check CLUSTER INT dataset", {
    res.class <- ds.class(x='D')
    expect_length(res.class, 3)
    expect_gte(length(res.class$cluster.int1), 1)
    expect_true("data.frame" %in% res.class$cluster.int1)
    expect_gte(length(res.class$cluster.int2), 1)
    expect_true("data.frame" %in% res.class$cluster.int2)
    expect_gte(length(res.class$cluster.int3), 1)
    expect_true("data.frame" %in% res.class$cluster.int3)

    res.length <- ds.length(x='D')
    expect_length(res.length, 4)
    expect_length(res.length$`length of D in cluster.int1`, 1)
    expect_equal(res.length$`length of D in cluster.int1`, 13)
    expect_length(res.length$`length of D in cluster.int2`, 1)
    expect_equal(res.length$`length of D in cluster.int2`, 13)
    expect_length(res.length$`length of D in cluster.int3`, 1)
    expect_equal(res.length$`length of D in cluster.int3`, 13)
    expect_equal(res.length$`total length of D in all studies combined`, 39)

    res.colnames <- ds.colnames(x='D')
    expect_length(res.colnames, 3)
    expect_length(res.colnames$cluster.int1, 13)
    expect_true(all(res.colnames$cluster.int1 %in% c("idSurgery", "trtGrp", "intSurgery", "nDoctors", "idDoctor", "intDoctor", "nPatients", "Male", "age", "BMI", "diabetes", "incid_rate", "private")))
    expect_length(res.colnames$cluster.int2, 13)
    expect_true(all(res.colnames$cluster.int2 %in% c("idSurgery", "trtGrp", "intSurgery", "nDoctors", "idDoctor", "intDoctor", "nPatients", "Male", "age", "BMI", "diabetes", "incid_rate", "private")))
    expect_length(res.colnames$cluster.int3, 13)
    expect_true(all(res.colnames$cluster.int3 %in% c("idSurgery", "trtGrp", "intSurgery", "nDoctors", "idDoctor", "intDoctor", "nPatients", "Male", "age", "BMI", "diabetes", "incid_rate", "private")))

    res.class.idsurgery <- ds.class(x='D$idSurgery')
    expect_length(res.class.idsurgery, 3)
    expect_length(res.class.idsurgery$cluster.int1, 1)
    expect_equal(res.class.idsurgery$cluster.int1, "factor")
    expect_length(res.class.idsurgery$cluster.int2, 1)
    expect_equal(res.class.idsurgery$cluster.int2, "factor")
    expect_length(res.class.idsurgery$cluster.int3, 1)
    expect_equal(res.class.idsurgery$cluster.int3, "factor")

    res.length.idsurgery <- ds.length(x='D$idSurgery')
    expect_length(res.length.idsurgery, 4)
    expect_length(res.length.idsurgery$`length of D$idSurgery in cluster.int1`, 1)
    expect_equal(res.length.idsurgery$`length of D$idSurgery in cluster.int1`, 1056)
    expect_length(res.length.idsurgery$`length of D$idSurgery in cluster.int2`, 1)
    expect_equal(res.length.idsurgery$`length of D$idSurgery in cluster.int2`, 991)
    expect_length(res.length.idsurgery$`length of D$idSurgery in cluster.int3`, 1)
    expect_equal(res.length.idsurgery$`length of D$idSurgery in cluster.int3`, 1094)
    expect_length(res.length.idsurgery$`total length of D$idSurgery in all studies combined`, 1)
    expect_equal(res.length.idsurgery$`total length of D$idSurgery in all studies combined`, 3141)

    res.class.trtgrp <- ds.class(x='D$trtGrp')
    expect_length(res.class.trtgrp, 3)
    expect_length(res.class.trtgrp$cluster.int1, 1)
    expect_equal(res.class.trtgrp$cluster.int1, "factor")
    expect_length(res.class.trtgrp$cluster.int2, 1)
    expect_equal(res.class.trtgrp$cluster.int2, "factor")
    expect_length(res.class.trtgrp$cluster.int3, 1)
    expect_equal(res.class.trtgrp$cluster.int3, "factor")

    res.length.trtgrp <- ds.length(x='D$trtGrp')
    expect_length(res.length.trtgrp, 4)
    expect_length(res.length.trtgrp$`length of D$trtGrp in cluster.int1`, 1)
    expect_equal(res.length.trtgrp$`length of D$trtGrp in cluster.int1`, 1056)
    expect_length(res.length.trtgrp$`length of D$trtGrp in cluster.int2`, 1)
    expect_equal(res.length.trtgrp$`length of D$trtGrp in cluster.int2`, 991)
    expect_length(res.length.trtgrp$`length of D$trtGrp in cluster.int3`, 1)
    expect_equal(res.length.trtgrp$`length of D$trtGrp in cluster.int3`, 1094)
    expect_length(res.length.trtgrp$`total length of D$trtGrp in all studies combined`, 1)
    expect_equal(res.length.trtgrp$`total length of D$trtGrp in all studies combined`, 3141)

    res.class.intsurgery <- ds.class(x='D$intSurgery')
    expect_length(res.class.intsurgery, 3)
    expect_length(res.class.intsurgery$cluster.int1, 1)
    expect_equal(res.class.intsurgery$cluster.int1, "numeric")
    expect_length(res.class.intsurgery$cluster.int2, 1)
    expect_equal(res.class.intsurgery$cluster.int2, "numeric")
    expect_length(res.class.intsurgery$cluster.int3, 1)
    expect_equal(res.class.intsurgery$cluster.int3, "numeric")

    res.length.intsurgery <- ds.length(x='D$intSurgery')
    expect_length(res.length.intsurgery, 4)
    expect_length(res.length.intsurgery$`length of D$intSurgery in cluster.int1`, 1)
    expect_equal(res.length.intsurgery$`length of D$intSurgery in cluster.int1`, 1056)
    expect_length(res.length.intsurgery$`length of D$intSurgery in cluster.int2`, 1)
    expect_equal(res.length.intsurgery$`length of D$intSurgery in cluster.int2`, 991)
    expect_length(res.length.intsurgery$`length of D$intSurgery in cluster.int3`, 1)
    expect_equal(res.length.intsurgery$`length of D$intSurgery in cluster.int3`, 1094)
    expect_length(res.length.intsurgery$`total length of D$intSurgery in all studies combined`, 1)
    expect_equal(res.length.intsurgery$`total length of D$intSurgery in all studies combined`, 3141)

    res.class.nDoctors <- ds.class(x='D$nDoctors')
    expect_length(res.class.nDoctors, 3)
    expect_length(res.class.nDoctors$cluster.int1, 1)
    expect_equal(res.class.nDoctors$cluster.int1, "integer")
    expect_length(res.class.nDoctors$cluster.int2, 1)
    expect_equal(res.class.nDoctors$cluster.int2, "integer")
    expect_length(res.class.nDoctors$cluster.int3, 1)
    expect_equal(res.class.nDoctors$cluster.int3, "integer")

    res.length.nDoctors <- ds.length(x='D$nDoctors')
    expect_length(res.length.nDoctors, 4)
    expect_length(res.length.nDoctors$`length of D$nDoctors in cluster.int1`, 1)
    expect_equal(res.length.nDoctors$`length of D$nDoctors in cluster.int1`, 1056)
    expect_length(res.length.nDoctors$`length of D$nDoctors in cluster.int2`, 1)
    expect_equal(res.length.nDoctors$`length of D$nDoctors in cluster.int2`, 991)
    expect_length(res.length.nDoctors$`length of D$nDoctors in cluster.int3`, 1)
    expect_equal(res.length.nDoctors$`length of D$nDoctors in cluster.int3`, 1094)
    expect_length(res.length.nDoctors$`total length of D$nDoctors in all studies combined`, 1)
    expect_equal(res.length.nDoctors$`total length of D$nDoctors in all studies combined`, 3141)

    res.class.iddoctor <- ds.class(x='D$idDoctor')
    expect_length(res.class.iddoctor, 3)
    expect_length(res.class.iddoctor$cluster.int1, 1)
    expect_equal(res.class.iddoctor$cluster.int1, "factor")
    expect_length(res.class.iddoctor$cluster.int2, 1)
    expect_equal(res.class.iddoctor$cluster.int2, "factor")
    expect_length(res.class.iddoctor$cluster.int3, 1)
    expect_equal(res.class.iddoctor$cluster.int3, "factor")

    res.length.iddoctor <- ds.length(x='D$idDoctor')
    expect_length(res.length.iddoctor, 4)
    expect_length(res.length.iddoctor$`length of D$idDoctor in cluster.int1`, 1)
    expect_equal(res.length.iddoctor$`length of D$idDoctor in cluster.int1`, 1056)
    expect_length(res.length.iddoctor$`length of D$idDoctor in cluster.int2`, 1)
    expect_equal(res.length.iddoctor$`length of D$idDoctor in cluster.int2`, 991)
    expect_length(res.length.iddoctor$`length of D$idDoctor in cluster.int3`, 1)
    expect_equal(res.length.iddoctor$`length of D$idDoctor in cluster.int3`, 1094)
    expect_length(res.length.iddoctor$`total length of D$idDoctor in all studies combined`, 1)
    expect_equal(res.length.iddoctor$`total length of D$idDoctor in all studies combined`, 3141)

    res.class.intdoctor <- ds.class(x='D$intDoctor')
    expect_length(res.class.intdoctor, 3)
    expect_length(res.class.intdoctor$cluster.int1, 1)
    expect_equal(res.class.intdoctor$cluster.int1, "numeric")
    expect_length(res.class.intdoctor$cluster.int2, 1)
    expect_equal(res.class.intdoctor$cluster.int2, "numeric")
    expect_length(res.class.intdoctor$cluster.int3, 1)
    expect_equal(res.class.intdoctor$cluster.int3, "numeric")

    res.length.intdoctor <- ds.length(x='D$intDoctor')
    expect_length(res.length.intdoctor, 4)
    expect_length(res.length.intdoctor$`length of D$intDoctor in cluster.int1`, 1)
    expect_equal(res.length.intdoctor$`length of D$intDoctor in cluster.int1`, 1056)
    expect_length(res.length.intdoctor$`length of D$intDoctor in cluster.int2`, 1)
    expect_equal(res.length.intdoctor$`length of D$intDoctor in cluster.int2`, 991)
    expect_length(res.length.intdoctor$`length of D$intDoctor in cluster.int3`, 1)
    expect_equal(res.length.intdoctor$`length of D$intDoctor in cluster.int3`, 1094)
    expect_length(res.length.intdoctor$`total length of D$intDoctor in all studies combined`, 1)
    expect_equal(res.length.intdoctor$`total length of D$intDoctor in all studies combined`, 3141)

    res.class.npatients <- ds.class(x='D$nPatients')
    expect_length(res.class.npatients, 3)
    expect_length(res.class.npatients$cluster.int1, 1)
    expect_equal(res.class.npatients$cluster.int1, "integer")
    expect_length(res.class.npatients$cluster.int2, 1)
    expect_equal(res.class.npatients$cluster.int2, "integer")
    expect_length(res.class.npatients$cluster.int3, 1)
    expect_equal(res.class.npatients$cluster.int3, "integer")

    res.length.npatients <- ds.length(x='D$nPatients')
    expect_length(res.length.npatients, 4)
    expect_length(res.length.npatients$`length of D$nPatients in cluster.int1`, 1)
    expect_equal(res.length.npatients$`length of D$nPatients in cluster.int1`, 1056)
    expect_length(res.length.npatients$`length of D$nPatients in cluster.int2`, 1)
    expect_equal(res.length.npatients$`length of D$nPatients in cluster.int2`, 991)
    expect_length(res.length.npatients$`length of D$nPatients in cluster.int3`, 1)
    expect_equal(res.length.npatients$`length of D$nPatients in cluster.int3`, 1094)
    expect_length(res.length.npatients$`total length of D$nPatients in all studies combined`, 1)
    expect_equal(res.length.npatients$`total length of D$nPatients in all studies combined`, 3141)

    res.class.male <- ds.class(x='D$Male')
    expect_length(res.class.male, 3)
    expect_length(res.class.male$cluster.int1, 1)
    expect_equal(res.class.male$cluster.int1, "factor")
    expect_length(res.class.male$cluster.int2, 1)
    expect_equal(res.class.male$cluster.int2, "factor")
    expect_length(res.class.male$cluster.int3, 1)
    expect_equal(res.class.male$cluster.int3, "factor")

    res.length.male <- ds.length(x='D$Male')
    expect_length(res.length.male, 4)
    expect_length(res.length.male$`length of D$Male in cluster.int1`, 1)
    expect_equal(res.length.male$`length of D$Male in cluster.int1`, 1056)
    expect_length(res.length.male$`length of D$Male in cluster.int2`, 1)
    expect_equal(res.length.male$`length of D$Male in cluster.int2`, 991)
    expect_length(res.length.male$`length of D$Male in cluster.int3`, 1)
    expect_equal(res.length.male$`length of D$Male in cluster.int3`, 1094)
    expect_length(res.length.male$`total length of D$Male in all studies combined`, 1)
    expect_equal(res.length.male$`total length of D$Male in all studies combined`, 3141)

    res.class.age <- ds.class(x='D$age')
    expect_length(res.class.age, 3)
    expect_length(res.class.age$cluster.int1, 1)
    expect_equal(res.class.age$cluster.int1, "numeric")
    expect_length(res.class.age$cluster.int2, 1)
    expect_equal(res.class.age$cluster.int2, "numeric")
    expect_length(res.class.age$cluster.int3, 1)
    expect_equal(res.class.age$cluster.int3, "numeric")

    res.length.age <- ds.length(x='D$age')
    expect_length(res.length.age, 4)
    expect_length(res.length.age$`length of D$age in cluster.int1`, 1)
    expect_equal(res.length.age$`length of D$age in cluster.int1`, 1056)
    expect_length(res.length.age$`length of D$age in cluster.int2`, 1)
    expect_equal(res.length.age$`length of D$age in cluster.int2`, 991)
    expect_length(res.length.age$`length of D$age in cluster.int3`, 1)
    expect_equal(res.length.age$`length of D$age in cluster.int3`, 1094)
    expect_length(res.length.age$`total length of D$age in all studies combined`, 1)
    expect_equal(res.length.age$`total length of D$age in all studies combined`, 3141)

    res.class.bmi <- ds.class(x='D$BMI')
    expect_length(res.class.bmi, 3)
    expect_length(res.class.bmi$cluster.int1, 1)
    expect_equal(res.class.bmi$cluster.int1, "numeric")
    expect_length(res.class.bmi$cluster.int2, 1)
    expect_equal(res.class.bmi$cluster.int2, "numeric")
    expect_length(res.class.bmi$cluster.int3, 1)
    expect_equal(res.class.bmi$cluster.int3, "numeric")

    res.length.bmi <- ds.length(x='D$BMI')
    expect_length(res.length.bmi, 4)
    expect_length(res.length.bmi$`length of D$BMI in cluster.int1`, 1)
    expect_equal(res.length.bmi$`length of D$BMI in cluster.int1`, 1056)
    expect_length(res.length.bmi$`length of D$BMI in cluster.int2`, 1)
    expect_equal(res.length.bmi$`length of D$BMI in cluster.int2`, 991)
    expect_length(res.length.bmi$`length of D$BMI in cluster.int3`, 1)
    expect_equal(res.length.bmi$`length of D$BMI in cluster.int3`, 1094)
    expect_length(res.length.bmi$`total length of D$BMI in all studies combined`, 1)
    expect_equal(res.length.bmi$`total length of D$BMI in all studies combined`, 3141)

    res.class.private <- ds.class(x='D$private')
    expect_length(res.class.private, 3)
    expect_length(res.class.private$cluster.int1, 1)
    expect_equal(res.class.private$cluster.int1, "factor")
    expect_length(res.class.private$cluster.int2, 1)
    expect_equal(res.class.private$cluster.int2, "factor")
    expect_length(res.class.private$cluster.int3, 1)
    expect_equal(res.class.private$cluster.int3, "factor")

    res.length.private <- ds.length(x='D$private')
    expect_length(res.length.private, 4)
    expect_length(res.length.private$`length of D$private in cluster.int1`, 1)
    expect_equal(res.length.private$`length of D$private in cluster.int1`, 1056)
    expect_length(res.length.private$`length of D$private in cluster.int2`, 1)
    expect_equal(res.length.private$`length of D$private in cluster.int2`, 991)
    expect_length(res.length.private$`length of D$private in cluster.int3`, 1)
    expect_equal(res.length.private$`length of D$private in cluster.int3`, 1094)
    expect_length(res.length.private$`total length of D$private in all studies combined`, 1)
    expect_equal(res.length.private$`total length of D$private in all studies combined`, 3141)

    res.class.diabetes <- ds.class(x='D$diabetes')
    expect_length(res.class.diabetes, 3)
    expect_length(res.class.diabetes$cluster.int1, 1)
    expect_equal(res.class.diabetes$cluster.int1, "factor")
    expect_length(res.class.diabetes$cluster.int2, 1)
    expect_equal(res.class.diabetes$cluster.int2, "factor")
    expect_length(res.class.diabetes$cluster.int3, 1)
    expect_equal(res.class.diabetes$cluster.int3, "factor")

    res.length.diabetes <- ds.length(x='D$diabetes')
    expect_length(res.length.diabetes, 4)
    expect_length(res.length.diabetes$`length of D$diabetes in cluster.int1`, 1)
    expect_equal(res.length.diabetes$`length of D$diabetes in cluster.int1`, 1056)
    expect_length(res.length.diabetes$`length of D$diabetes in cluster.int2`, 1)
    expect_equal(res.length.diabetes$`length of D$diabetes in cluster.int2`, 991)
    expect_length(res.length.diabetes$`length of D$diabetes in cluster.int3`, 1)
    expect_equal(res.length.diabetes$`length of D$diabetes in cluster.int3`, 1094)
    expect_length(res.length.diabetes$`total length of D$diabetes in all studies combined`, 1)
    expect_equal(res.length.diabetes$`total length of D$diabetes in all studies combined`, 3141)

    res.class.incid_rate <- ds.class(x='D$incid_rate')
    expect_length(res.class.incid_rate, 3)
    expect_length(res.class.incid_rate$cluster.int1, 1)
    expect_equal(res.class.incid_rate$cluster.int1, "integer")
    expect_length(res.class.incid_rate$cluster.int2, 1)
    expect_equal(res.class.incid_rate$cluster.int2, "integer")
    expect_length(res.class.incid_rate$cluster.int3, 1)
    expect_equal(res.class.incid_rate$cluster.int3, "integer")

    res.length.incid_rate <- ds.length(x='D$incid_rate')
    expect_length(res.length.incid_rate, 4)
    expect_length(res.length.incid_rate$`length of D$incid_rate in cluster.int1`, 1)
    expect_equal(res.length.incid_rate$`length of D$incid_rate in cluster.int1`, 1056)
    expect_length(res.length.incid_rate$`length of D$incid_rate in cluster.int2`, 1)
    expect_equal(res.length.incid_rate$`length of D$incid_rate in cluster.int2`, 991)
    expect_length(res.length.incid_rate$`length of D$incid_rate in cluster.int3`, 1)
    expect_equal(res.length.incid_rate$`length of D$incid_rate in cluster.int3`, 1094)
    expect_length(res.length.incid_rate$`total length of D$incid_rate in all studies combined`, 1)
    expect_equal(res.length.incid_rate$`total length of D$incid_rate in all studies combined`, 3141)
})

#
# Tear down
#

# context("CLUSTER_INT::datachk::shutdown")

test_that("shutdown", {
    ds_expect_variables(c("D"))
})

disconnect.studies.dataset.cluster.int()

# context("CLUSTER_INT::datachk::done")
