% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dsm_var_gam.R
\name{dsm_var_gam}
\alias{dsm_var_gam}
\title{Prediction variance estimation assuming independence}
\usage{
dsm_var_gam(
  dsm.obj,
  pred.data,
  off.set,
  seglen.varname = "Effort",
  type.pred = "response"
)
}
\arguments{
\item{dsm.obj}{a model object fitted by \code{\link{dsm}}.}

\item{pred.data}{either: a single prediction grid or list of prediction
grids. Each grid should be a \code{data.frame} with the same columns as the
original data.}

\item{off.set}{a a vector or list of vectors with as many elements as there
are in \code{pred.data}. Each vector is as long as the number of rows in the
corresponding element of \code{pred.data}. These give the area associated with
each prediction cell. If a single number is supplied it will be replicated
for the length of \code{pred.data}.}

\item{seglen.varname}{name for the column which holds the segment length
(default value \code{"Effort"}).}

\item{type.pred}{should the predictions be on the "response" or "link"
scale? (default \code{"response"}).}
}
\value{
a \code{list} with elements
\itemize{
\item \code{model} the fitted model object
\item \code{pred.var} variance of the regions given in \code{pred.data}.
\item \code{bootstrap} logical, always \code{FALSE}
\item \code{model} the fitted model with the extra term
\item \code{dsm.object} the original model (\code{dsm.obj} above)
}
}
\description{
If one is willing to assume the the detection function and spatial model are
independent, this function will produce estimates of variance of predictions
of abundance, using the result that squared coefficients of variation will
add.
}
\examples{
\dontrun{
 library(Distance)
 library(dsm)

 # load the Gulf of Mexico dolphin data (see ?mexdolphins)
 data(mexdolphins)

 # fit a detection function and look at the summary
 hr.model <- ds(distdata, truncation=6000,
                key = "hr", adjustment = NULL)
 summary(hr.model)

 # fit a simple smooth of x and y
 mod1 <- dsm(count~s(x, y), hr.model, segdata, obsdata)

 # Calculate the variance
 # this will give a summary over the whole area in mexdolphins$preddata
 mod1.var <- dsm_var_gam(mod1, preddata, off.set=preddata$area)
}
}
\author{
David L. Miller
}
