% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dct_add_row.R
\name{dct_add_row}
\alias{dct_add_row}
\title{Add row(s) to a taxonomic database}
\usage{
dct_add_row(
  tax_dat,
  taxonID = NULL,
  scientificName = NULL,
  taxonomicStatus = NULL,
  acceptedNameUsageID = NULL,
  acceptedNameUsage = NULL,
  new_dat = NULL,
  fill_taxon_id = dct_options()$fill_taxon_id,
  fill_usage_id = dct_options()$fill_usage_id,
  taxon_id_length = dct_options()$taxon_id_length,
  stamp_modified = dct_options()$stamp_modified,
  stamp_modified_by_id = dct_options()$stamp_modified_by_id,
  stamp_modified_by = dct_options()$stamp_modified_by,
  strict = dct_options()$strict,
  ...
)
}
\arguments{
\item{tax_dat}{Dataframe; taxonomic database in DwC format.}

\item{taxonID}{Character or numeric vector; values to add to taxonID column.
Ignored if \code{new_dat} is not \code{NULL}.}

\item{scientificName}{Character vector; values to add to scientificName
column. Ignored if \code{new_dat} is not \code{NULL}.}

\item{taxonomicStatus}{Character vector; values to add to taxonomicStatus
column. Ignored if \code{new_dat} is not \code{NULL}.}

\item{acceptedNameUsageID}{Character or numeric vector; values to add to
acceptedNameUsageID column. Ignored if \code{new_dat} is not \code{NULL}.}

\item{acceptedNameUsage}{Character vector; values to add to acceptedNameUsage
column. Ignored if \code{new_dat} is not \code{NULL}.}

\item{new_dat}{A dataframe including columns corresponding to one or more of
the above arguments, except for \code{tax_dat}. Other DwC terms can also be
included as additional columns. All rows in \code{new_dat} will be appended to the
input data (\code{tax_dat}).}

\item{fill_taxon_id}{Logical vector of length 1; if \code{taxon_id} is not provided, should values in the taxonID column be filled in by generating them automatically from the scientificName? If the \code{taxonID} column does not yet exist it will be created. Default \code{TRUE}.}

\item{fill_usage_id}{Logical vector of length 1; if \code{usage_id} is not provided, should values in the acceptedNameUsageID column be filled in by matching acceptedNameUsage to scientificName? If the \code{acceptedNameUsageID} column does not yet exist it will be created. Default \code{TRUE}.}

\item{taxon_id_length}{Numeric vector of length 1; how many characters should be included in automatically generated values of taxonID? Must be between 1 and 32, inclusive. Default \code{32}.}

\item{stamp_modified}{Logical vector of length 1; should the \code{modified} column of any newly created or modified row include a timestamp with the date and time of its creation/modification? If the \code{modified} column does not yet exist it will be created. Default \code{TRUE}.}

\item{stamp_modified_by_id}{Logical vector of length 1; should the \code{modifiedByID} column of any newly created or modified row include the ID of the
current user? If the \code{modifiedByID} column does not yet exist it will be created; note that
this is a non-DWC standard column, so \code{"modifiedByID"} is required in
\code{extra_cols}. The current user ID can be specified with the \code{user_id} option. Default \code{FALSE}.}

\item{stamp_modified_by}{Logical vector of length 1; should the \code{modifiedBy} column of any newly created or modified row include the name of the
current user? If the \code{modifiedBy} column does not yet exist it will be created; note that
this is a non-DWC standard column, so \code{"modifiedBy"} is required in
\code{extra_cols}. The current user can be specified with the \code{user_name} option. Default \code{FALSE}.}

\item{strict}{Logical vector of length 1; should taxonomic checks be run on the updated taxonomic database? Default \code{FALSE}.}

\item{...}{Additional data to add, specified as sets of named
character or numeric vectors; e.g., \code{parentNameUsageID = "6SH4"}. The name of
each must be a valid column name for data in DwC format. Ignored if \code{new_dat}
is not \code{NULL}.}
}
\value{
Dataframe; taxonomic database in DwC format.
}
\description{
Add one or more rows to a taxonomic database in Darwin Core (DwC) format.
}
\details{
\code{fill_taxon_id} and \code{fill_usage_id} only act on the newly added data (they
do not fill columns in \code{tax_dat}).

If "taxonID" is not provided for the new row and \code{fill_taxon_id} is \code{TRUE},
a value for taxonID will be automatically generated from the md5 hash digest
of the scientific name.

To modify settings used for validation if \code{strict} is \code{TRUE},
use \code{dct_options()}.
}
\examples{
tibble::tibble(
  taxonID = "123",
  scientificName = "Foogenus barspecies",
  acceptedNameUsageID = NA_character_,
  taxonomicStatus = "accepted"
) |>
  dct_add_row(
    scientificName = "Foogenus barspecies var. bla",
    parentNameUsageID = "123",
    nameAccordingTo = "me",
    strict = TRUE
  )
}
