% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fun.R
\name{prepRing}
\alias{prepRing}
\alias{prepRing.shapeLayout}
\alias{prepRing.simpleLayout}
\alias{prepRing.numeric}
\alias{prepRing.polygonLayout}
\title{Format a Search Layout into Rings for Analysis}
\usage{
prepRing(x, ...)

\method{prepRing}{shapeLayout}(x, scVar = NULL, notSearched = NULL, silent = FALSE, ...)

\method{prepRing}{simpleLayout}(x, ...)

\method{prepRing}{numeric}(x, srad, ...)

\method{prepRing}{polygonLayout}(x, ...)
}
\arguments{
\item{x}{a search plot layout as imported and processed by 
\code{\link{initLayout}} into a \code{shapeLayout}, \code{polygonLayout}, or 
\code{simpleLayout} object, or a bare vector of carcass distances if search 
plots are all circular with the same radius and no unsearched area within 
the search radius.}

\item{...}{ignored}

\item{scVar}{name of the search class variable (optional), a column in the
shape file for the search polygons. \code{scVar} is ignored if \code{x} is not
a \code{shapeLayout} object.}

\item{notSearched}{name of the search class(es) in \code{scVar} that represent
unsearched areas. Applicable only if \code{x} is a \code{shapeLayout} object
and \code{scVar} is provided. Polygons associated with \code{scVar} values in
\code{notSearched} are not included in the rings characterization of the site.
Also, turbines with no polygons that are not \code{notSearched} are not included
in the rings.}

\item{silent}{Processing shape files into rings may take several minutes. By
default, \code{prepRing} prints periodic notice of the progress of the
calculations for shape files. To suppress these notices, use 
\code{silent = TRUE}.}

\item{srad}{search radius for data when \code{x} = bare vector of carcass
observation distances.}
}
\value{
an object of class \code{rings}, which is a list with components
 \describe{
   \item{\code{$rdat}}{list of data frames giving the area searched 
     (\code{"exposure"}), in a 1 meter ring with outer radius \code{"r"} and 
     the number of carcasses found \code{"ncarc"} in each ring, with search 
     class \code{scVar} optional. There is also a summary data frame 
     \code{$rdat[["total"]]} that sums the exposures and carcass counts for 
     all turbines across the site. The \code{$rdat[["total"]]} is the data 
     frame used in fitting the GLMs.}
   \item{\code{$rpA}}{list of data frames giving the proportion of area 
     included in the searches (\code{"pinc"}) in each ring (\code{"r"}). and 
     the number of carcasses found \code{"ncarc"} in each ring, with search 
     class \code{scVar} optional. There is also a summary data frame that 
     sums the exposures and carcass counts for all turbines across the site. 
     The \code{$rpA} data frames are used in estimating the probability of 
     carcasses falling in the searched area at each turbine, which, in turn 
     is used for calculating \code{dwp}}
   \item{\code{$srad}}{the maximum search radius at any of the turbines}
   \item{\code{$ncarc}}{vector of the number of carcasses at each turbine with
     names equal to the turbine names.}
   \item{\code{$scVar}}{name of the search class variable(s) or \code{NULL}}
   \item{\code{$tcenter}}{locations of turbine centers (nturb x 2 matrix) with
     UTMs of turbine locations. Column names are \code{X} and \code{Y}. Row
     names are the names of the turbines.}
 }
}
\description{
A function for creating a characterization of the search plot at each turbine by
 rings. The ground around each turbine is divided into 1 meter concentric rings
 out to the limit of the search plot. The amount of area searched in each ring
 and search class (if a search class column is present in the data) at each
 turbine is calculated, along with the fraction of area searched in each ring.
 In addition, sum totals of the area in each ring and the average fraction of
 the area searched in each ring across all turbines at the site are tallied as well.
 This is a convenient structure for the Poisson regressions that are used to
 estimate the carcass distributions with respect to distance from the turbines,
 the probabilities of carcasses landing in the searched areas, and the fraction
 of carcasses in the searched area.
}
