% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/outputParamFig.R
\name{outputParamFig}
\alias{outputParamFig}
\title{A function That Exports SEM diagrams based on dySEM models}
\usage{
outputParamFig(fit, figtype = NULL, writeTo = NULL, fileName = NULL)
}
\arguments{
\item{fit}{Input object from fitted \code{lavaan} model.}

\item{figtype}{A character input of what type of model is desired:
\itemize{
\item "unstandardized" for unstandardized path coefficients.
\item "standardized" for standardized path coefficients.
\item "labels" for labelled parameters.
}}

\item{writeTo}{A character string specifying a directory path to where the output file of the path diagram should be saved.
If set to “.”, the file will be written to the current working directory.
The default is \code{NULL} (which will throw an error), and examples use a temporary directory created by \code{tempdir()}.}

\item{fileName}{A character string specifying a desired base name for the output file.
If a \code{fileName} not provided (i.e., fileName = \code{NULL}), then a default will be used depending on the specified \code{figtype}
(e.g., "dySEM_figure unstd", "dySEM_figure std", or "dySEM_figure lab").
The specified name will automatically be appended with the \code{.png} file extension.}
}
\value{
A \code{qgraph} object of the desired SEM path diagram, which is simultaneously exported as a \code{.png} file to the specified directory.
}
\description{
This function takes the model from fitted \code{dySEM} scripts and exports \code{.png} path diagram figures of expected output.
}
\details{
\itemize{
\item The function uses \code{semPlot::semPaths()} to create a \code{qgraph} object of the desired SEM path diagram.
\item After execution, a \code{semPlot::semPaths()} message will be printed to the console confirming the directory path of the saved output file.
\item If a file with the same name already exists in the user's chosen directory, it will be overwritten.
}
}
\examples{
dvnx <- scrapeVarCross(
  dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
  x_delim2 = "_", distinguish_1 = "1", distinguish_2 = "2"
)

sat.config.script <- scriptCor(dvnx,
  lvname = "Sat", constr_dy_meas = "none",
  constr_dy_struct = "none"
)

sat.config.mod <- lavaan::cfa(sat.config.script,
  data = commitmentQ, std.lv = FALSE,
  auto.fix.first = FALSE, meanstructure = TRUE
)

outputParamFig(sat.config.mod,
  figtype = "standardized",
  writeTo = tempdir(), fileName = "dCFA_configural"
)

dvnxy <- scrapeVarCross(
  dat = commitmentQ, x_order = "spi", x_stem = "sat.g", x_delim1 = ".",
  x_delim2 = "_", distinguish_1 = "1", distinguish_2 = "2",
  y_order = "spi", y_stem = "com", y_delim1 = ".", y_delim2 = "_"
)

apim.indist.script <- scriptAPIM(dvnxy, lvxname = "Sat", lvyname = "Com", est_k = TRUE)

apim.indist.mod <- lavaan::cfa(apim.indist.script,
  data = commitmentQ, std.lv = FALSE,
  auto.fix.first = FALSE, meanstructure = TRUE
)

outputParamFig(apim.indist.mod,
  figtype = "standardized",
  writeTo = tempdir(), fileName = "APIM_indist"
)
}
