% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract.R
\name{get_dynfields}
\alias{get_dynfields}
\title{Helper function to get a tibble of the relevant fields from heemod output}
\usage{
get_dynfields(heemodel, payoffs, discount, fname = NA)
}
\arguments{
\item{heemodel}{A health economic model object from the \emph{heemod} package (see \link[heemod:heemod-package]{heemod::heemod-package}).}

\item{payoffs}{Field names of payoffs of interest (string vector)}

\item{discount}{Name of parameter providing discount rate per cycle (string)}

\item{fname}{Export data to a .CSV file of this name, if given (character)}
}
\value{
Tibble of payoffs taken from the heemod model, by intervention and model timestep (\code{model_time}).

The field \code{vt} is calculated as \code{(1+i)^(1-model_time)}, where \code{i} is the discount rate per model timestep set in the \emph{heemod} model through the parameter \code{disc_cycle}. This can be useful in 'rolling-up' payoff values to the timestep in which they were incurred.

An additional set of payoffs (identified with a "_rup" suffix) provides calculations of the payoffs as at the start of the timestep in which they were incurred, i.e. original payoff / \code{vt}.
}
\description{
Helper function to get a tibble of the relevant fields from heemod output
}
\examples{
democe <- get_dynfields(
   heemodel = oncpsm,
   payoffs = c("cost_daq_new", "cost_total", "qaly"),
   discount = "disc"
   )
head(democe)
}
\seealso{
\link[heemod:heemod-package]{heemod::heemod-package}
}
