% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tibble.R
\name{tibble_as_list}
\alias{tibble_as_list}
\title{Convert a tibble to a list of lists}
\usage{
tibble_as_list(tib)
}
\arguments{
\item{tib}{A tibble}
}
\value{
A list with the same number of lists as there were rows in \code{tib}
}
\description{
Convert a tibble to a list of lists
}
\examples{
library(tibble)

tib <- tibble(
  a = c(1, 2),
  b = list(log10, sqrt),
  c = c("parrot", "quest"),
  .object_class = list(c("myobject", "list"), c("yourobject", "list"))
)

li <- tibble_as_list(tib)

li
}
\seealso{
list_as_tibble extract_row_to_list mapdf
}
