% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/method_process_definition.R
\name{definition}
\alias{definition}
\alias{is_ti_method}
\title{Create a definition}
\usage{
definition(
  method,
  wrapper,
  manuscript = NULL,
  container = NULL,
  package = NULL,
  parameters = parameter_set()
)

is_ti_method(method)
}
\arguments{
\item{method}{Meta information on the TI method (see \code{\link[=def_method]{def_method()}}).}

\item{wrapper}{Meta information on the wrapper itself (see \code{\link[=def_wrapper]{def_wrapper()}}).}

\item{manuscript}{Meta information on the manuscript, if applicable (see \code{\link[=def_manuscript]{def_manuscript()}}).}

\item{container}{Meta information on the container in which the wrapper resides, if applicable (see \code{\link[=def_container]{def_container()}}).}

\item{package}{Meta information on the package in which the wrapper resides, if applicable (see \code{\link[=def_package]{def_package()}}).}

\item{parameters}{Meta information on the parameters of the TI method (see \code{\link[=def_parameters]{def_parameters()}}).}
}
\value{
A method definition
}
\description{
A definition contains meta information on a TI method and various aspects thereof.
For brevity, the example only contains a minimum example, check the documentation
of the \verb{def_*} helper functions for more extensive examples.
}
\examples{
library(dynparam)
definition(
  method = def_method(id = "some_method"),
  wrapper = def_wrapper(input_required = "expression"),
  parameters = parameter_set(
    integer_parameter(id = "k", default = 5L, distribution = uniform_distribution(3L, 20L))
  )
)
}
\keyword{create_ti_method}
