% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read_cutadapt.R
\name{read_info_file}
\alias{read_info_file}
\title{Read cutadapt info files}
\usage{
read_info_file(file, delim = "\\t", col_select = NULL, ...)
}
\arguments{
\item{file}{Path to the cutadapt info file (TSV).}

\item{delim}{Field delimiter (default = "\\t").}

\item{col_select}{Optional tidyselect specification of which columns to read.}

\item{...}{Additional arguments passed to [vroom::vroom()].}
}
\value{
A tibble with the parsed 'cutadapt' information. Column names are standardized.
}
\description{
Read the `--info-file` output generated by cutadapt for adapter trimming.
Column structure differs depending on whether the input came from
Nanopore (ONT) or Illumina sequencing.
}
\details{
- `read_info_file()` (Illumina) returns columns:
  `Seq.id`, `n_errors`, `start_adap`, `end_adap`, `seq_before_adap`,
  `matching_seq`, `seq_after_adap`, `adap_name`, `QScores_seq_before`,
  `QScores_matching`, `QScores_after`.
}
\examples{
test_info <- system.file("extdata", "cutadapt_info_illumina.txt", package="eDNAfuns")
df_illumina <- read_info_file(test_info)



}
