% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/write_PCR.R
\name{write_indexing_PCR}
\alias{write_indexing_PCR}
\title{Write Indexing PCR Spreadsheet}
\usage{
write_indexing_PCR(
  data,
  name,
  ss_template = "1naS-F_dj4SNmND5nJ5TKhMX3TikmRS00ILKjfg_Ucgc"
)
}
\arguments{
\item{data}{A tibble or dataframe with at least the columns:
\describe{
  \item{Well}{Well position}
  \item{Sample}{Sample identifier}
  \item{Column}{Plate column (used to split data across sheet sections)}
}}

\item{name}{Character. Name for the new Google Sheet that will be created.}

\item{ss_template}{Character. ID of the template sheet to copy from
(default: `"1naS-F_dj4SNmND5nJ5TKhMX3TikmRS00ILKjfg_Ucgc"`).}
}
\value{
A Google Sheet object (as returned by [googlesheets4::gs4_create()])
  with the data written into the correct plate layout.
}
\description{
Creates a new Google Sheet for indexing PCRs from a template,
fills in the sample information, and writes it into the correct
ranges of the sheet.
}
\details{
This function:
1. Creates a new Google Sheet with the given `name`.
2. Copies the template sheet into it.
3. Splits the input `data` by plate column.
4. Writes each split dataframe into its designated range of the sheet.
}
\examples{
#Examples are not executed because the function requires identification in Google 
\dontrun{
my_data <- tibble::tibble(
 Well = c("A1","A2"),
  Sample = c("Sample1","Sample2"),
  Column = c(1,2)
)
write_indexing_PCR(my_data, "PCR_001")
}

}
