#' Spatial coordinates of European stations
#'
#' A dataset containing the longitude and latitude of monitoring stations used
#' in the eFCM examples and vignettes.
#' @name LonLat
#' @docType data
#' @usage data(LonLat)
#' @format A data frame with \eqn{n} rows and 2 variables:
#' \describe{
#'   \item{lon}{Longitude (decimal degrees, WGS84).}
#'   \item{lat}{Latitude (decimal degrees, WGS84).}
#' }
#' @examples
#' data(LonLat)
#' head(LonLat)
NULL

#' Counterfactual daily precipitation data
#'
#' An example dataset stored as an object of class \code{"fdata"},
#' suitable for direct use with \code{\link{fcm}}
#' @name cf_data
#' @docType data
#' @usage data(cf_data)
#' @format An object of class \code{"fdata"}
#' @examples
#' data(cf_data)
#' dim(cf_data)
NULL

#' Example fitted eFCM object
#'
#' An example output of the \code{\link{fcm}} function, obtained by fitting
#' the exponential Factor Copula Model to a subset of precipitation data.
#' @name fit
#' @docType data
#' @usage data(fit)
#' @format An object of class \code{"fcm"}
#' @examples
#' data(fit)
#' summary(fit)
NULL


#' Weekly Maxima of Counterfactual Precipitation in Europe
#'
#' Weekly maxima of precipitation under natural-only forcing over a European domain.
#' This processed dataset is used in the vignettes and examples to illustrate
#' model fitting and attribution mapping with eFCM.
#'
#' @name counterfactual
#' @docType data
#' @usage data(counterfactual)
#' @format A numeric matrix or data frame with dimensions (weeks × stations).
#'   Rows index consecutive winter-season weeks; columns correspond to stations.
#'   Units are millimetres.
#' @details This dataset is derived from daily-resolution counterfactual simulations
#'   (not included in the package due to size constraints) by aggregating to weekly
#'   maxima. It is intended for examples, tests, and vignettes where a lightweight
#'   dataset is preferred.
#' @keywords datasets
#' @examples
#' data(counterfactual)
#' dim(counterfactual)
#' plot(apply(counterfactual, 1, mean), type = "l",
#'      xlab = "Week", ylab = "Mean precipitation (mm)")
NULL
