% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inference.R
\name{BIC.fcm}
\alias{BIC.fcm}
\title{Bayesian Information Criterion (BIC) for fcm objects}
\usage{
\method{BIC}{fcm}(object, ...)
}
\arguments{
\item{object}{An object of class \code{fcm}, created by \code{\link[=fcm]{fcm()}}.}

\item{...}{Currently unused.}
}
\value{
A numeric scalar giving the BIC value for the fitted model.
}
\description{
Compute the BIC value for a fitted \code{fcm} model using the formula:
\deqn{\mathrm{BIC} = -2 \cdot \log L + \log(n) \cdot p}
where \eqn{n} is the number of observations and \eqn{p} is the number of parameters.
}
\seealso{
\code{\link[=AIC.fcm]{AIC.fcm()}}, \code{\link[=AICc.fcm]{AICc.fcm()}}
}
