% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/echoice2.R
\name{ec_lol_tidy1}
\alias{ec_lol_tidy1}
\title{Convert "list of lists" format to long "tidy" format}
\usage{
ec_lol_tidy1(data_lol, X = "X", y = "y")
}
\arguments{
\item{data_lol}{A list of data frames containing design matrices and response vectors}

\item{X}{The column name of the design matrix, default: "X"}

\item{y}{The column name of the response vector, default: "y"}
}
\value{
A tidy data frame with columns for each design matrix column, the response vector,
and an id column indicating which data frame the row came from
}
\description{
Convert "list of lists" format to long "tidy" format
}
\examples{
\donttest{
loldata<-list()
loldata[[1]]=list()
loldata[[1]]$y = c(1,2)
loldata[[1]]$X= data.frame(brand1=c(1,0, 1,0),brand2=c(0,1, 0,1),price=c(1,2))
loldata[[2]]=list()
loldata[[2]]$y = c(1,1)
loldata[[2]]$X= data.frame(brand1=c(1,0, 1,0),brand2=c(0,1, 0,1),price=c(1,2))
ec_lol_tidy1(loldata)
}

}
