% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cord.R
\name{cord}
\alias{cord}
\title{Model based ordination with Gaussian copulas}
\usage{
cord(obj, nlv = 2, n.samp = 500, seed = NULL)
}
\arguments{
\item{obj}{object of either class \code{\link[mvabund]{manyglm}}, 
or  \code{\link[mvabund]{manyany}} with ordinal models \code{\link[ordinal]{clm}}}

\item{nlv}{number of latent variables (default = 2, for plotting on a scatterplot)}

\item{n.samp}{integer (default = 500), number of sets residuals used for importance sampling 
(optional, see detail)}

\item{seed}{integer (default = NULL), seed for random number generation (optional)}
}
\value{
\code{loadings} latent factor loadings
\code{scores} latent factor scores
\code{sigma} covariance matrix estimated with \code{nlv} latent variables
\code{theta} precision matrix estimated with \code{nlv} latent variables
\code{BIC} BIC of estimated model
\code{logL} log-likelihood of estimated model
}
\description{
Model based ordination with Gaussian copulas
}
\section{Details}{

\code{cord} is used to fit a Gaussian copula factor analytic model to multivariate discrete data, such as co-occurrence (multi species) data in ecology. The model is estimated using importance sampling with \code{n.samp} sets of randomised quantile or "Dunn-Smyth" residuals (Dunn & Smyth 1996), and the \code{\link{factanal}} function. The seed is controlled so that models with the same data and different predictors can be compared.
}

\section{Author(s)}{

Gordana Popovic <g.popovic@unsw.edu.au>.
}

\section{References}{

Dunn, P.K., & Smyth, G.K. (1996). Randomized quantile residuals. Journal of Computational and Graphical Statistics 5, 236-244.

Popovic, G. C., Hui, F. K., & Warton, D. I. (2018). A general algorithm for covariance modeling of discrete data. Journal of Multivariate Analysis, 165, 86-100.
}

\section{See also}{

\code{\link{plot.cord}}
}

\examples{
abund <- spider$abund
spider_mod <- stackedsdm(abund,~1, data = spider$x, ncores=2) 
spid_lv=cord(spider_mod)
plot(spid_lv,biplot = TRUE)
}
